// ConvertMimeType.java
// $Id: ConvertMimeType.java,v 1.2 1997/07/30 14:05:41 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.converter;

import w3c.www.mime.*;
import java.io.*;

public class ConvertMimeType implements Convert {

  public void setInitialClass(Class c){}

  public Object defaultValue() {
    return MimeType.TEXT_PLAIN;
  }

  public String toString(Object O) {
    return ((MimeType)O).toString();
  }

  public Object toObject(String S) {
    try {
      return new MimeType(S);
    } catch (MimeTypeFormatException ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

  public Class classConverted() {
    try {
      return Class.forName("w3c.www.mime.MimeType");
    } catch (ClassNotFoundException ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

}
