// AsciiResourceFilter.java
// $Id: AsciiResourceFilter.java,v 1.2 1997/07/30 14:04:46 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.ascii;

import java.io.*;

/**
 * The FilenameFilter for Ascii Resources Files.
 */

public class AsciiResourceFilter implements FilenameFilter {


  /**
   * Tests if a specified file should be included in a file list. 
   * @param dir - the directory in which the file was found. 
   *        name - the name of the file. 
   * @return true if the name should be included in the file list; 
   * false otherwise.
   */
  public boolean accept(File dir, String name) {
    File f = new File(dir,name);
    if (f.isDirectory()) return false;
    String ext = name.substring(name.length()-4);
    if (ext.equals(".txt")) return true;
    return false;
  }

}
