// Test.java
// $Id: Test.java,v 1.3 1997/07/30 14:04:13 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

import java.io.*;
import java.util.*;
import java.net.URL;

import w3c.www.mime.*;
import w3c.tools.resources.event.*;
import w3c.tools.resources.impl.*;
import w3c.tools.resources.simple.*;
import w3c.tools.resources.ascii.*;
import w3c.tools.resources.property.*;
import w3c.tools.resources.http.*;
import w3c.tools.resources.tests.*;
import w3c.tools.resources.impl.ResourceContextImpl;

public class Test {

  public static void main (String args[]) {
    String url       = null;
    String mode      = null;
    String directory = null;
    String dirName   = null;
    boolean list     = false;

    String simple_p = "/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/simple.sp";

    String prop_p = "/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/property.sp";

    String spacedir = "/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/space";
    
    String wwwdir = "/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/WWW";

    if (args.length == 0) {
      System.out.println("option : -dir directory -url url -mode simple|prop");
      System.exit(0);
    }

    for (int i = 0 ; i < args.length ; i++) {
      if ( args[i].equals("-url") ) {
	url = args[++i];
      } else if ( args[i].equals("-mode") ) {
	mode = args[++i];
      } else if ( args[i].equals("-dir") ) {
	directory = args[++i];
	dirName = args[++i];
      } else if ( args[i].equals("-list") ) {
	list = true;
      }      
    }

    Resource r   = null;
    File rootdir = new File(spacedir);
    // make the space
    ResourceSpaceImpl space = new ResourceSpaceImpl();
    Properties P = new Properties();
    try {
      FileInputStream property = null;
      if (mode == null)
	property = new FileInputStream(prop_p);
      else  if (mode.equals("simple"))
	property = new FileInputStream(simple_p);
      else  if (mode.equals("prop"))
	property = new FileInputStream(prop_p);
      else property = new FileInputStream(prop_p);
      P.load(property);
      HTTPResourceContextImpl ctxt = new HTTPResourceContextImpl(space,null);
      File WWWdir = new File(wwwdir);
      ctxt.addProperty("directory",WWWdir);
      ctxt.addProperty("extensibleFlag", Boolean.TRUE);
      space.init(P, ctxt);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
    }

    // now space is loaded :
    
    if (url != null) {
      ResourceReference targetref = 
	space.resolve(new LookupState(space, url));
      if (targetref == null)
	System.out.println("* not found '"+url);
      else {
	try {
	  HTTPResource resource = (HTTPResource)targetref.lock();
	  System.out.println("found. ");
	  System.out.println("--> name    : "+resource.getName());
	  System.out.println("--> urlPath : "+resource.getUrlPath());
	  if (list) {
	    Enumeration e = ((DirectoryResource)
			     resource).enumerateResourceIdentifiers(true);
	    System.out.println(" <index of : "+resource.getName());
	    while (e.hasMoreElements()) {
	      System.out.println("   * "+(String)e.nextElement());
	    }
	    System.out.println(" <end>\n");
// 	    e = ((DirectoryResource)resource).listChildren();
// 	    while (e.hasMoreElements()) {
// 	      ResourceReference rr = (ResourceReference)e.nextElement();
// 	      try {
// 		HTTPResource hr = (HTTPResource)rr.lock();
// 		  System.out.println(" <*>");
// 		System.out.println(" <> name    : "+hr.getName());
// 		System.out.println(" <> urlPath : "+hr.getUrlPath());
// 	      } finally {
// 		rr.unlock();
// 	      }
// 	    }
	  }
	} finally {
	  targetref.unlock();
	}
      }
    }

    if (directory != null) {
      ResourceReference targetref = 
	space.resolve(new LookupState(space, "/"));
      if (targetref == null)
	System.out.println("* not found /");
      else {
	try {
	  DirectoryResource dir = (DirectoryResource)targetref.lock();
	  HTTPResourceContextImpl context = 
	    new HTTPResourceContextImpl(space,targetref);
	  context.addProperty("directory", new File(directory));
	  context.addProperty("name",dirName);
	  DirectoryResource link = new DirectoryResource();
	  ResourceReference rr = dir.registerChild(link,context);
	  try {
	    link = (DirectoryResource)rr.lock();
	    System.out.println("--> name    : "+link.getName());
	    System.out.println("--> urlPath : "+link.getUrlPath());
	  } finally {
	    rr.unlock();
	  }
	} catch (ResourceInitException e) {
	  e.printStackTrace();
	} catch (ChildNotSupportedException e) {
	  e.printStackTrace();
	} finally {
	  targetref.unlock();
	}
      }
    }

    //    System.exit(0); /// STOP
    System.out.println("~~~~~~~~ checkpoint ~~~~~~~~~");
    space.checkpoint();
    System.out.println("* done.");
  }

}





