// ResourceSaver.java
// $Id: ResourceSaver.java,v 1.5 1997/07/30 14:03:36 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

import java.util.*;

/**
 * A resource saver manages persistents resources.
 * particular it must provide :
 * <dl>
 * <dt>Resource saving
 * <dd>A way to save a resource in a resource space. 
 * <dt>Resource loading
 * <dd>A way to load a resource from a resource space.
 * </dl>
 */

public interface ResourceSaver {

  public PropertyHolder getPropertyHolder(Runner run, Resource r);

  public void save (Resource r)
    throws ChildNotSupportedException;

  public ResourceReference load(PersistentReference pr, 
				ResourceReference container)
    throws ClassNotFoundException;

  public void delete (Resource r);

  public void delete (String name, ResourceReference container);

  public void init(ResourceSpace space, Properties P)
    throws ResourceSaverInitException;

}
