// ResourceReference.java
// $Id: ResourceReference.java,v 1.3 1997/07/30 14:03:32 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

/**
 * Resolving a resource provides back a resource reference.
 * Resource <em>references</em> are the basis for handling an eventual
 * cache between the store of the resource and its memory image (ie
 * the resource instance).
 * <p>All resource spaces must provide some notion of resource reference,
 * even if the actual implementation is empty.
 * <p>A typical access to a resource looks like:
 * <pre>
 * ResourceReference rr = space.resolve("/x/y/z");
 * try {
 *    Resource r = rr.lock();
 *    // Fiddle with the resource:
 *    rr.setValue("foo", new Integer(10));
 * } finally {
 *    // Make sure to unlock the reference:
 *    rr.unlock();
 * </pre>
 * @see ResourceSpace#resolve
 */

public interface ResourceReference {

    /**
     * Lock the refered resource in memory.
     * @return A real pointer to the resource.
     */

    public Resource lock();

    /**
     * Unlock that resource from memory.
     */

    public void unlock();

    /**
     * Is that resource reference locked ?
     */

    public boolean isLocked();
}
