// DirectoryResource.java
// $Id: ExitloopCommand.java,v 1.5 1997/07/08 07:01:42 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi;

import java.util.*;

import w3c.www.http.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.util.*;

/**
 * Implementation of the SSI <code>exitloop</code> command.  
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */
public class ExitloopCommand implements ControlCommand {
  private final static String  NAME  = "exitloop";
  private final static boolean debug = true;

  private static final String keys[] = {
    "name",
    "command",
    "var",
    "equals"
  };

  protected static Hashtable exitloops = null;

  static {
     exitloops = new Hashtable(23);
  }

  public String getValue(Dictionary variables, String var) {
    return null;
  }

  protected static int getPosition(String name) 
    throws ControlCommandException
  {
    Integer pos = (Integer)exitloops.get(name);
    if (pos == null)
      throw new ControlCommandException(NAME,"Position unknown.");
    else return pos.intValue();
  }

  public void setPosition(SSIResource resource,
			  CommandRegistry registry,
			  ArrayDictionary parameters,
			  Dictionary variables,
			  int position) 
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null)
      exitloops.put(resource.getURLPath()+":"+name, new Integer(position));
  }

  public Reply execute(SSIResource resource
		       , Request request
		       , ArrayDictionary parameters
		       , Dictionary variables) 
  {
    return resource.createCommandReply(request, HTTP.OK);
  }

  protected boolean check(CommandRegistry registry
			  , ArrayDictionary parameters
			  , Dictionary variables)
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    String command  = (String) values[1];
    String var      = (String) values[2];
    String equals   = (String) values[3];
    
    if ((command == null) || (var == null) || (equals == null))
      return true;
    Command cmd = registry.lookupCommand(command);
    String value = cmd.getValue(variables,var);
    return value.equals(equals);
  }

  public int jumpTo(SSIResource resource,
		    CommandRegistry registry,
		    ArrayDictionary parameters,
		    Dictionary variables)
    throws ControlCommandException    
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null) {
      if (! check(registry,parameters,variables))
	return (getPosition(resource.getURLPath()+":"+name)+1);
      return (EndloopCommand.getPosition(resource.getURLPath()+":"+name)+1);
    }
    throw new ControlCommandException(NAME,"name not initialized.");    
  }

  public String getName() {
    return NAME;
  }

}
