// GhostNestDirectoryResource.java
// $Id: GhostNestDirectoryResource.java,v 1.2 1997/09/26 15:05:55 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.*;
import java.util.*;

import w3c.tools.store.*;
import w3c.tools.sorter.*;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.indexer.* ;
import w3c.jigsaw.html.* ;
import w3c.www.http.*;


/**
 * A directory Resource wich can contain ghost child.
 */

public class GhostNestDirectoryResource extends DirectoryResource {

  /**
   * Try creating a default resource having the given name.
   * This method will make its best effort to create a default resource
   * having this name in the directory. 
   * it will check the pre-defined admin extensions and look for a match.
   * and admin allows to do so, it
   * will create a sub-directory resource.
   * @param name The name of the resource to try to create.
   * @return A HTTPResource instance, if possible, <strong>null</strong>
   *    otherwise.
   */

  public synchronized HTTPResource createDefaultResource(String name) {
    // Don't automagically create resources of name '..' or '.'
    if (name.equals("..") || name.equals("."))
      return null ;
    // Is there a file with such a name ?
    File file = new File(getDirectory(), name) ;
    // Prepare a set of default parameters for the resource:
    Hashtable defs = new Hashtable(10) ;
    defs.put("identifier", name);
    updateDefaultChildAttributes(defs);
    // Try to get the indexer to create the resource:
    ResourceContext context  = getContext();
    HTTPResource    resource = null;
    ResourceIndexer indexer  = null;
    ResourceIndexer lastidx  = null;
    while ( context != null ) {
      // Lookup for next indexer in hierarchy:
      do {
	indexer = getIndexer(context);
	context = context.getParent();
      } while ((indexer == lastidx) && (context != null));
      // Is this a usefull indexer ?
      if ((lastidx = indexer) != null ) {
	resource = indexer.createResource(this
					  , null
					  , getDirectory()
					  , name
					  , defs) ;
	if ( resource != null )
	  break;
      }
    }
    // Did we finally create a resource ?
    if (( resource != null ) && (! (resource instanceof NullResource))) {
      // Register this child in our store:
      addResource(resource) ;
      // Update or create any relevant negotiable resource:
      if ( getNegotiableFlag() ) 
	updateNegotiableResource(name) ;
      markModified() ;
    }
    return resource ;
  }

}
