// DirectoryLister.java
// $Id: DirectoryLister.java,v 1.2 1997/09/04 11:26:29 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;
import java.util.* ;

import w3c.tools.store.*;
import w3c.tools.sorter.*;
import w3c.www.mime.*;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.indexer.* ;
import w3c.jigsaw.html.* ;
import w3c.www.http.*;


/**
 * A Directory lister, reply with an HTML doc listing the resources 
 * of its parent directory.
 */

public class DirectoryLister extends FilteredResource {

  /**
   * GET on a lister, generate the parent directory listing.
   * @param request The request to handle.
   */
  
  public Reply get(Request request)
    throws HTTPException, ClientException
  {
    HTTPResource p = getParent() ;
    if (p != null) {
      if (p instanceof DirectoryResource)
	return ((DirectoryResource)p).getDirectoryListing(request) ;
      else
	return p.get(request);
    } else {
      return createDefaultReply(request, HTTP.NO_CONTENT) ;
    }
  }

}
