// DefaultMapEntry.java
// $Id: DefaultMapEntry.java,v 1.6 1996/08/18 19:18:25 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.map ;

import java.io.*;

class DefaultMapEntry extends MapEntry {
    public DefaultMapEntry() {}

    // Shouldn't be called, but just in case:
    public boolean matches(Point p)
    {
	return true;
    }

    protected void unpickleRest(DataInputStream in)
    {
	// nil
    }
    
    public void pickle(DataOutputStream out)
	throws IOException
    {
	super.pickle(out);
	out.writeInt(DEFAULT);
    }

    protected final void parseRestNCSA(String line)
	throws MapException
    {
	URL = line.trim();
	if(URL.equals(""))
	    throw new MapException("missing default URL");
    }

    protected final void parseRestW3C(String line)
	throws MapException 
    {
	parseRestNCSA(line);
	
    }
	    
}
