// ControlResource.java
// $Id: ControlResource.java,v 1.2 1997/06/25 13:05:29 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.util.*;
import java.io.*;
import w3c.util.*;
import w3c.tools.store.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.http.*;

class ControlResourceEnumeration implements Enumeration {
    private static final String ids[] = {
	"checkpoint",
	"save",
	"restart",
	"shutdown"
    };
    int idx = 0;

    public boolean hasMoreElements() {
	return false;
    }

    public Object nextElement() {
//	if ( idx >= ids.length )
	throw new NoSuchElementException("control resource enumeration");
//	return ids[idx++];
    }

    ControlResourceEnumeration() {
	this.idx = 0;
    }
}

public class ControlResource extends HTTPResource 
                             implements ContainerInterface {
    protected httpd server = null;

    // no resource store available

    public boolean hasResourceStore() {
	return false;
    }

    public ResourceStore getResourceStore(ResourceStoreHolder holder) {
	return null;
    }

    public void registerResource(String n, Resource c, Hashtable d) {
	throw new RuntimeException("static container");
    }

    public HTTPResource createDefaultResource(String name) {
	throw new RuntimeException("static container");
    }

    public void delete(String name) {
	throw new RuntimeException("static container");
    }	

    protected void saveProperties() {
	ObservableProperties props = server.getProperties();
	File propfile = new File((String)props.get(httpd.PROPS_P));
        // Did we guessed were the place to save the property file ?
	if ( propfile == null) {
	    // FIXME
	} else {
	    try {
		FileOutputStream fout = new FileOutputStream(propfile);
		server.getProperties().save (fout, "Jigsaw written") ;
		fout.close() ;
	    } catch (IOException ex) {
		// FIXME
	    }
	}
	server.errlog ("Properties " + propfile + " have been saved.");
    }

    public Resource lookup(String name) {
	if ( name.equalsIgnoreCase("checkpoint") ) {
	    server.checkpoint();
	} else if ( name.equalsIgnoreCase("save") ) {
	    saveProperties();
	    server.checkpoint();
	} else if ( name.equalsIgnoreCase("restart") ) {
	    server.restart();
	} else if ( name.equalsIgnoreCase("stop") ) {
	    server.shutdown();
	}
	return this;
    }

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	return new ControlResourceEnumeration();
    }

    public ControlResource(httpd server) {
	this.server = server;
    }
}
    
