// ConfigResource.java
// $Id: ConfigResource.java,v 1.4 1997/07/03 12:00:08 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.util.*;

import w3c.jigsaw.resources.*;
import w3c.tools.store.*;
import w3c.jigsaw.auth.RealmCatalogResource;

class ConfigResourceEnumeration implements Enumeration {
    private static final String ids[] = {
	"space",
	"properties",
	"indexers",
	"realms",
	"control"
    };
    int idx = 0;

    public boolean hasMoreElements() {
	return idx < ids.length;
    }

    public Object nextElement() {
	if ( idx >= ids.length )
	    throw new NoSuchElementException("config resource enumeration");
	return ids[idx++];
    }

    ConfigResourceEnumeration() {
	this.idx = 0;
    }
}

class PropertySetEnumeration implements Enumeration {
    Enumeration e = null;

    public boolean hasMoreElements() {
	return e.hasMoreElements();
    }

    public Object nextElement() {
	return ((Resource) e.nextElement()).getIdentifier();
    }

    protected PropertySetEnumeration(Enumeration e) {
	this.e = e;
    }

}

class PropertiesConfig extends ContainerResource {
    httpd server = null;

    public boolean hasResourceStore() {
	return false;
    }

    public ResourceStore getResourceStore(ResourceStoreHolder holder) {
	return null;
    }

    public void registerResource(String n, Resource c, Hashtable d) {
	throw new RuntimeException("static container");
    }

    public HTTPResource createDefaultResource(String name) {
	throw new RuntimeException("static container");
    }

    public void delete(String name) {
	throw new RuntimeException("static container");
    }	

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	return new PropertySetEnumeration(server.enumeratePropertySet());
    }

    public Resource lookup(String name) {
	return server.getPropertySet(name);
    }

    protected PropertiesConfig(httpd server) {
	this.server = server;
    }

}

public class ConfigResource extends ContainerResource {
    protected httpd server = null;
    protected ContainerResource propConfig = null;
    protected RealmCatalogResource realmConfig = null;
    protected ControlResource controlConfig = null;

    public boolean hasResourceStore() {
	return false;
    }

    public ResourceStore getResourceStore(ResourceStoreHolder holder) {
	return null;
    }

    public void registerResource(String n, Resource c, Hashtable d) {
	throw new RuntimeException("static container");
    }

    public HTTPResource createDefaultResource(String name) {
	throw new RuntimeException("static container");
    }

    public void delete(String name) {
	throw new RuntimeException("static container");
    }	

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	return new ConfigResourceEnumeration();
    }

    public Resource lookup(String name) {
	if ( name.equals("space") ) {
	    return server.getEditRoot();
	} else if ( name.equals("properties") ) {
	    return propConfig;
	} else if ( name.equals("indexers") ) {
	    return server.getIndexersCatalog();
	} else if ( name.equals("realms" ) ) {
	    return realmConfig;
	} else if ( name.equals("control") ) {
	    return controlConfig;
	}
	return null;
    }

    public ConfigResource(httpd server) {
	this.server = server;
	this.propConfig = new PropertiesConfig(server);
	this.realmConfig = new RealmCatalogResource(server);
	this.controlConfig = new ControlResource(server);
    }

}
