// FormCardHandler.java
// $Id: FormCardHandler.java,v 1.2 1997/01/24 11:59:59 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms;

import w3c.jigsaw.http.* ;

/**
 * An HTML form card handler.
 * The form handler class defined the behavior that form handlers are 
 * required to provide. 
 * The form manager ensures that calls to <code>notifyBeginProcessing</code>,
 * <code>notifyChange</code> and <code>notifyEndProcessing</code> are
 * atomic. This means that either the same thread will perform the three
 * calls (without another thread preempting it), or it will fail with some
 * exception, and won't call all notify callbacks.
 */

public class FormCardHandler {

    /**
     * Notify the form handler that some card processing begins.
     * @param request The request that will be processed.
     * @param card The card whose processing is starting.
     * @exception HTTPException If the processing failed.
     */

    public void notifyBeginProcessing(FormCardResource card, Request request)
	throws FormProcessingException
    {
	return ;
    }

    /**
     * Notify the form handler that some card processing is finished.
     * @param request The request that we have finished to process.
     * @param card The card whose processing is finished.
     * @return An String encoded location (if relocation required), relative
     * to the form card resource, or <strong>null</strong>.
     * @exception FormProcessingException If the processing failed.
     */

    public String notifyEndProcessing(FormCardResource card, Request request) 
	throws FormProcessingException
    {
	return null ;
    }

    /**
     * Notify the form handler that some field has changed its value.
     * @param name The name of the field that changed.
     * @param value Its new value.
     * @exception FormFieldException If the provided value was rejected
     *     by the handler.
     */

    public void notifyChange (FormFieldInterface field, Object value) 
	throws FormFieldException
    {
	return ;
    }

    /**
     * Notify the form handler that a button was clicked.
     * @param label The button label.
     */

    public void notifyButtonClick(String label) 
	throws FormProcessingException
    {
	return ;
    }

    /**
     * Perform any update needed by the form.
     * This method is called before creating the HTML for the form content. If
     * the form state (field's value, or list of cards) needs some update, it
     * is the right place to do it.
     * @param card The card to be updated if needed.
     * @return A fresh instance of FormCardResource, if the cardwas rebuilt,
     *    or <strong>null</strong> if the original card was preserved.
     */

    public FormCardResource updateFormCard(FormCardResource card) {
	return null;
    }
     
}
