// EncodingField.java
// $Id: EncodingField.java,v 1.1 1996/04/10 13:41:37 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms;

import java.util.*;

import w3c.jigsaw.html.* ;

/**
 * Edit a list of encodings.
 * Not very user friendly, but does the work.
 */

public class EncodingField extends TextField {

    /*
     * Initialize a EncodingField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (String) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

    /**
     * Create an encoding field.
     * @param name The field's name.
     * @param title The field's title.
     * @param url The field's helper URL.
     * @param value The default value.
     */

    public EncodingField(String name, String title, String url, String value) {
	super(name, title, url, value) ;
    }

    public EncodingField() {
    }

}


