// ShortcutHelper.java
// $Id: ShortcutHelper.java,v 1.6 1997/08/21 09:32:57 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import w3c.jigadm.*;
import w3c.jigsaw.admin.*;
import w3c.tools.store.Attribute;
import w3c.tools.widgets.ImageButton;

public class ShortcutHelper extends ResourceHelper {

    private class ShortcutActionListener implements ActionListener {
	
        public void actionPerformed(ActionEvent ae) {
	    String command = ae.getActionCommand();
	    
	    if(command.equals("add Auth")) {
		addAuthFilter();
	    } else if(command.equals("add Pass")) {
		addPassDirectory();
	    } else if(command.equals("back")) {
		initShortcutPanel();
	    }
	}
    }

    RemoteResourceWrapper   rrw = null;
    RemoteResource rr = null;
    RemoteResource[] child = null;
    AttributesHelper filterAttr;
    private boolean initialized = false;
    Properties prop;
    Panel widget;
    Panel shortcutPanel = null;
    Panel centerComp;

    protected void addPassDirectory() {
	PassDirectoryShortcut pds = new PassDirectoryShortcut(this);
	pds.initialize(rrw, prop);
	widget.setVisible(false);
	widget.remove(centerComp);
	Panel interp = new Panel(new BorderLayout());
	interp.add("Center", pds.getComponent());
	centerComp = interp;
	Button back = new Button("Back to Shortcut menu");
	back.setActionCommand("back");
	back.addActionListener(new ShortcutActionListener());
	interp.add("South", back);
	widget.add("Center", centerComp);
	widget.validate();
	widget.setVisible(true);
    }

    protected void addAuthFilter() {
	RemoteResourceWrapper fw;
	fw = addFilter("w3c.jigsaw.auth.GenericAuthFilter");
	// this must add a special widget with an easy-to-use
	// realm editor.
	filterAttr = new AttributesHelper();
	try {
	    filterAttr.initialize(fw, null);
	} catch (RemoteAccessException ex) {
	    errorPopup("RemoteAccessException",ex);
	}
	widget.setVisible(false);
	widget.remove(centerComp);
	Panel interp = new Panel(new BorderLayout());
	interp.add("Center", filterAttr.getComponent());
	centerComp = interp;
	Button back = new Button("Back to Shortcut menu");
	back.setActionCommand("back");
	back.addActionListener(new ShortcutActionListener());
	interp.add("South", back);
	widget.add("Center", centerComp);
	widget.validate();
	widget.setVisible(true);
    }

    protected RemoteResourceWrapper addIndexer(String ident, String iclass) {
	if(ident.length() > 0) {
	    RemoteResource nrr;
	    try {
		nrr = rrw.getResource().registerResource(ident, iclass);
	    } catch (RemoteAccessException ex) {
	        errorPopup("RemoteAccessException",ex);
		return null;
	    }
	    RemoteResourceWrapper nrrw;
	    nrrw = new RemoteResourceWrapper(rrw, nrr, rrw.getBrowser());
	    rrw.getBrowser().insertNode(rrw, nrrw, ident);
	    return nrrw;
	}
	return null;
    }

    protected RemoteResourceWrapper addResource(String ident, String rclass) {
	if(ident.length() > 0) {
	    RemoteResource nrr;
	    try {
		nrr = rrw.getResource().registerResource(ident, rclass);
	    } catch (RemoteAccessException ex) {
	        errorPopup("RemoteAccessException",ex);
		return null;
	    }
	    RemoteResourceWrapper nrrw;
	    nrrw = new RemoteResourceWrapper(rrw, nrr, rrw.getBrowser());
	    rrw.getBrowser().insertNode(rrw, nrrw, ident);
	    return nrrw;
	}
	return null;
    }

    protected RemoteResourceWrapper addFilter(String rclass) {
	RemoteResource nrr;
	try {
	    nrr = rrw.getResource().registerFilter(null, rclass);
	} catch (RemoteAccessException ex) {
	    errorPopup("RemoteAccessException",ex);
	    return null;
	}
	return new RemoteResourceWrapper(rrw, nrr, rrw.getBrowser());
    }
    
    protected RemoteResourceWrapper getWrapper() {
	return rrw;
    }

    public Component getComponent() {
	return widget;
    }

    public void commitChanges() {
	return;
    }

    public boolean hasChanged() {    
	return false; // the changes are propagated instantly
    }

    public void resetChanges() {
    }

    public void clearChanged() {
    }

    public final String getTitle () {
	return "Shortcut";
    }

    public ShortcutHelper() {
	widget = new Panel();
    }

    protected void initShortcutPanel() {
	if(shortcutPanel == null) {
	    Panel tfp;
	    shortcutPanel = new Panel(new BorderLayout());
	    PropertyManager pm = PropertyManager.getPropertyManager();
	    
	    ScrollPane fsp = new ScrollPane();
	    GridBagLayout gbl = new GridBagLayout();
	    GridBagConstraints gbc = new GridBagConstraints();
	    Panel fspp = new Panel(gbl);
	    fsp.add(fspp);
	    Image im;
	    ImageButton ib;
	    Label l;
	    gbc.fill = GridBagConstraints.HORIZONTAL;
	    gbc.weightx = 0;
	    gbc.weighty = 0;
	    ShortcutActionListener sae = new ShortcutActionListener();

	    // short term hack
	    try {
		if (rr.isContainer()) {
		    im = Toolkit.getDefaultToolkit().getImage(
			pm.getIconLocation("link"));
		    ib = new ImageButton(im, "add Pass");
		    ib.addActionListener(sae);
		    gbc.gridwidth = 1;
		    gbl.setConstraints(ib, gbc);
		    fspp.add(ib);
		    
		    l = new Label("Add an Alias Directory");
		    gbc.gridwidth = GridBagConstraints.REMAINDER;
		    gbl.setConstraints(l, gbc);
		    fspp.add(l);
		}
	    } catch (RemoteAccessException ex) {
		// no more a container as the Resource died ;)
	    }

	    im = Toolkit.getDefaultToolkit().getImage(
		pm.getIconLocation("folder.sec"));
	    ib = new ImageButton(im, "add Auth");
	    ib.addActionListener(sae);
	    gbc.gridwidth = 1;
	    gbl.setConstraints(ib, gbc);
	    fspp.add(ib);
		
	    l = new Label("Add an Auth Filter");
	    gbc.gridwidth = GridBagConstraints.REMAINDER;
	    gbl.setConstraints(l, gbc);
	    fspp.add(l);
	    
	    shortcutPanel.add("Center", fspp);
	}
	widget.setVisible(false);
	if(centerComp != null)
	    widget.remove(centerComp);
	widget.add("Center", shortcutPanel);
	widget.validate();
	widget.setVisible(true);
	centerComp = shortcutPanel;
    }


    public void initialize(RemoteResourceWrapper rrw, Properties pr)
	throws RemoteAccessException
    {
	if(!initialized)
	    initialized = true;
	else
	    return;	
	
	this.rrw = rrw;
	rr = rrw.getResource();

	widget.setLayout(new BorderLayout());
	initShortcutPanel();
    }
}
