// Install.java for 1.0beta2
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

import java.util.*;
import java.io.*;
import w3c.jigsaw.http.*;

public class Install {

  Properties http_props  = null;
  Properties admin_props  = null;
  Properties props = null;

  public final String CONFIG_DIR = "config";
  public final String CONFIGADM_DIR = "configadm";
  public final String HTTP_PROPS = "http-server.props";
  public final String ADMIN_PROPS = "admin-server.props";
  public final String SERVER_PROPS = "server.props";
  public final String AUTH_DIR = "auth";
  public final String INDEXERS_DIR = "indexers";
  public final String JIGADM_DIR = "jigadm";
  public final String STORES_DIR = "stores";
  public final String WWW_DIR = "WWW";

  public final String comment = "Updated by Install";

  File config_dir       = null;
  File configadm_dir    = null;
  File http_props_file  = null;
  File admin_props_file = null;
  File www              = null;
  File root             = null;

  int warning = 0;

  private File check(File file) {
    if (! file.exists()) {
      warning++;
      System.out.println("WARNING: "+file+" NOT FOUND!");
      return null;
    }
    return file;
  }

  private void initialize () {
    root = check(root);
    config_dir = check( new File(root, CONFIG_DIR) );
    www = check( new File (root, WWW_DIR) );
    if (config_dir != null) {
      http_props_file = check( new File(config_dir, HTTP_PROPS) );
      admin_props_file = check( new File(config_dir, ADMIN_PROPS) );
      check( new File(config_dir, SERVER_PROPS) );
      check( new File(config_dir, AUTH_DIR) );
      check( new File(config_dir, INDEXERS_DIR) );
      check( new File(config_dir, JIGADM_DIR) );
      check( new File(config_dir, STORES_DIR) );
    }
    configadm_dir = check( new File(root, CONFIGADM_DIR) );
    if (configadm_dir != null) {
      check ( new File(configadm_dir, STORES_DIR) );
      check ( new File(configadm_dir, AUTH_DIR) );
    }
  }

  private void fail() {
    fail(null);
  }

  private void fail(String msg) {
    if (msg != null)
      System.out.println("[Installation failed]: "+msg);
    else 
      System.out.println("[Installation failed]");
    System.exit(1);
  }

  private Properties loadProps(File file) {
    Properties p = new Properties();
    FileInputStream in = null;
    try {
      in = new FileInputStream (file);
      p.load( in );
    } catch (Exception ex) {
      fail(ex.getMessage());
    } finally { 
      try { in.close(); } catch (Exception e) {}
    }
    return p;
  }

  private void saveProps(Properties p, File file) {
    FileOutputStream out = null;
    try {
      out = new FileOutputStream (file);
      p.save( out, comment );
    } catch (Exception ex) {
      fail(ex.getMessage());
    } finally {
      try { out.close(); } catch (Exception e) {}
    }
  }

  public void install() {
    initialize();
    if (root == null)
      fail();

    if (http_props_file == null)
      fail();
    System.out.println("Updating "+http_props_file+" ...");
    http_props = loadProps(http_props_file);
    try {
      http_props.put(httpd.PROPS_P, http_props_file.getCanonicalPath());
      http_props.put(httpd.ROOT_P, root.getCanonicalPath());
      http_props.put(httpd.CONFIG_P, config_dir.getCanonicalPath());
      http_props.put(httpd.ROOT_NAME_P, "root");
      if (www != null)
	http_props.put(httpd.SPACE_P, www.getCanonicalPath());
    } catch (IOException ex ) {
      fail(ex.getMessage());
    } finally {
      try { saveProps(http_props, http_props_file); } catch (Exception e) {}
    }

    if (admin_props_file == null)
      fail();
    System.out.println("Updating "+admin_props_file+" ...");
    admin_props = loadProps(admin_props_file);
    try {
      admin_props.put(httpd.PROPS_P, admin_props_file.getCanonicalPath());
      admin_props.put(httpd.ROOT_P, root.getCanonicalPath());
      if (configadm_dir != null)
	admin_props.put(httpd.CONFIG_P, configadm_dir.getCanonicalPath());
      admin_props.put(httpd.ROOT_NAME_P, "root");
    } catch (IOException ex ) {
      fail(ex.getMessage());
    } finally {
      try { 
	saveProps(admin_props, admin_props_file); }
      catch (Exception e) {
	System.out.println(e.getMessage());
      }
    }
    System.out.println("Installation complete with "+warning+" warning");
    System.out.println("type 'java w3c.jigsaw.Main -root "+root+
		       "' to launch Jigsaw.");
    System.out.println("type 'java w3c.jigadm.Main -root "+root+
		       " http://localhost:"+admin_props.get(httpd.PORT_P)+
		       "' to launch Jigsaw.");
  }

  public Install () {
    props = System.getProperties();
    this.root = new File(props.getProperty("user.dir", null));
  }

  public static void main (String args[]) {
    (new Install()).install();
  }

}
