// cacheStatistics.java
// $Id: cacheStatistics.java,v 1.2 1996/12/18 10:39:45 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.protocol.http.cache;

public class cacheStatistics {
    /**
     * Number of cache hits.
     */
    protected int hits = 0;
    /**
     * Number of cache misses.
     */
    protected int misses = 0;
    /**
     * Number of succesful revalidations.
     */
    protected int goodRevalidations = 0;
    /**
     * Number of unsuccessful revalidations.
     */
    protected int badRevalidations = 0;
    /**
     * Number of pending or dropped connections
     */
    protected int pendingConnections = 0;
    /**
     * Number of not cachable replies
     */
    protected int notCachableReplies = 0;
    /**
     * the number of straight replies, aka real hits.
     */
    protected int realHits = 0;
    /**
     * The start time, as a number of milliseconds since Java epoch.
     */
    protected long start_time = 0;

    /**
     * Increment the number of errors
     */
    
    protected final synchronized void incrNotCachable() {
	notCachableReplies++;
    }
    
    /**
     * Increment the number of straight replies and
     * decrement the number of pending connection
     * (it is a FINAL reply).
     */
    
    protected final synchronized void incrRealHits() {
	realHits++;
	pendingConnections--;
    }

    /**
     * Increment the number of pending connections
     */
    
    protected final synchronized void incrPending() {
	pendingConnections++;
    }

    /**
     * Decrement the number of pending connections
     */
    
    protected final synchronized void decrPending() {
	pendingConnections--;
    }

    /**
     * Increment the number of hits.
     */

    protected final synchronized void incrHits() {
	hits++;
    }

    /**
     * Increment the number of misses.
     */

    protected final synchronized void incrMisses() {
	misses++;
    }

    /**
     * Increment the number of good revalidations.
     */

    protected final synchronized void incrGoodRevalidations() {
	goodRevalidations++;
    }

    /**
     * Increment the number of bad revalidations.
     */

    protected final synchronized void incrBadRevalidations() {
	badRevalidations++;
    }

    /**
     * Get the number of replies that were not cachable
     */

    public int getNotCachable() {
	return notCachableReplies;
    }
    
    /**
     * Get the number of pending or dropped connections. This show how
     * many connections are active (ideally) and is used now to keep
     * track of dropped connections
     */

    public int getPending() {
	return pendingConnections;
    }

    /**
     * Get the number of real hits. A real hit is a direct answer from the
     * cache without asking for a revalidation.
     */

    public int getRealHits() {
	return realHits;
    }

    /**
     * Get the number of successful hits.
     * A hit is sucessful if a cache entry for the target existed <em>before
     * </em> that request. A successful hit can then account for either 
     * no revalidation at all, a good or a bad revalidation (but at least for
     * one of these).
     * @return The number of hits.
     */

    public int getHits() {
	return hits;
    }

    /**
     * Get the number of cache misses.
     * A miss happens one a request is made for a resource that doesn't exist
     * in the cache yet.
     * @return The number of misses.
     */

    public int getMisses() {
	return misses;
    }

    /**
     * Number of good revalidations.
     * A good revalidation is revalidation for which the origin server emitted
     * a <code>NOT_MODIFIED</code> status code.
     * @return The number of good revalidations.
     */

    public int getGoodRevalidations() {
	return goodRevalidations;
    }

    /**
     * Number of bad revalidations.
     * A bad revalidation is a revalidation that triggered a full reply from
     * the origin server.
     * @return The number of bad revalidations.
     */

    public int getBadRevalidations() {
	return badRevalidations;
    }

    /**
     * Get the start time as the number of milliseconds since Java epoch.
     * @return A long number of milliseconds.
     */

    public long getStartTime() {
	return start_time;
    }

    cacheStatistics() {
	start_time = System.currentTimeMillis();
    }

}
