package w3c.jigsaw.tests ;

import java.io.* ;

import w3c.tools.store.*;
import w3c.www.http.HTTP ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.* ;


public class DummyResource extends HTTPResource {
    protected byte[] bits  = null ;
    protected Reply  reply = null ;
    
    protected final static String headers =
	"HTTP/1.0 200 OK\r\n" +
	"Date: Thu, 1 Aug 1996 00:00:00 GMT\r\n" +
	"Content-Length: 4096\r\n" +
	"Content-Type: text/plain\r\n" +
	"Last-Modified: Thu, 1 Aug 1996 00:00:00 GMT\r\n" +
	"\r\n" ;

    public Reply get(Request request)
	throws HTTPException, ClientException
    {
	try {
	    request.getClient().getOutputStream().write(bits) ;
	    return reply;
	} catch(IOException ex) {
	    reply.setStatus(HTTP.NOT_FOUND) ;
	    throw new ClientException(request.getClient(), ex) ;
	} 
    }

    public void initialize(Object values[]) {
	super.initialize(values);
	// Precompute a fake reply:
	try {
	    reply = new Reply(null, (short) 1, (short) 1, HTTP.DONE);
	    ByteArrayOutputStream bytes = new ByteArrayOutputStream(5000);
	    DataOutputStream out   = new DataOutputStream(bytes);
	    out.writeBytes(headers);
	    for (int i = 0 ; i < 4096 ; i++) 
		out.write((byte) '*');
	    bits = bytes.toByteArray();
	} catch (Exception ex) {
	    ex.printStackTrace();
	    throw new HolderInitException("unable to pre-compute reply");
	}
    }
}
