// ExitStat.java
// $Id: ExitStat.java,v 1.6 1996/10/02 19:54:16 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.status ;

import java.util.Hashtable ;

import w3c.www.http.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

/**
 * The exit entity.
 * This entity provides a way to cleanly shut down the server. Has more and
 * more entities will have some state, and because most of the server code
 * is just dealing with caches, shutting down the server requires some
 * attention.
 * <p>This entity is (will) provide a clean way to solve this.
 */

public class ExitStat extends HTTPResource {
    
    /**
     * Get method of the exit exntity: shutdown the server.
     */

    public Reply get (Request request) 
	throws HTTPException
    {
	request.getClient().getServer().shutdown() ;
	Reply reply = createDefaultReply(request, HTTP.OK);
	reply.addPragma("no-cache");
	reply.setNoCache(null);
	reply.setContent("Please wait while server shuts down...");
	return reply;
    }

    public ExitStat () {
	super() ;
    }

}
