// BasicCommand.java
// $Id: BasicCommand.java,v 1.3 1996/08/22 19:07:41 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import w3c.www.http.HTTP ;
import w3c.jigsaw.http.* ;

/**
 * This class just adds some convenience functions for commands.
 * @author Antonio Ramirez <anto@mit.edu>
 */
public abstract class BasicCommand implements Command {
    protected static final String STATE_IF_MODIFIED_SINCE =
	"w3c.jigsaw.ssi.BasicCommand.If-Modified-Since" ;

    protected void handleSimpleIMS(Request request,
				   Reply reply)
    {
	long ims = request.getIfModifiedSince() ;
	if(ims == -1) {
	    Long IMS = (Long)
		request.getState(STATE_IF_MODIFIED_SINCE) ;
	    if(IMS != null) ims = IMS.longValue() ;
	}
	if(ims != -1) {
	    reply.setStatus(HTTP.NOT_MODIFIED) ;
	    reply.setLastModified(ims) ;
	}
    }
}
