// JigsawHttpServletRequest.java
// $Id: JigsawHttpServletRequest.java,v 1.4 1997/01/24 12:03:03 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.servlet;

import java.io.*;
import java.util.*;

import java.servlet.*;
import java.servlet.http.*;

import w3c.jigsaw.http.*;
import w3c.jigsaw.forms.*;
import w3c.www.http.*;
import w3c.jigsaw.auth.AuthFilter; // for auth infos access

/**
 *  @author Alexandre Rafalovitch <alex@access.com.au>
 *  @author Anselm Baird-Smith <abaird@w3.org>
 */

public class JigsawHttpServletRequest implements HttpServletRequest {
    /** 
     * The initial request.
     */
    private Request request;
    /**
     * The lazyly computed queryParameters hashtable.
     */
    private Hashtable queryParameters = null;
    
    private void prepareQueryParameters()
    {
	if( queryParameters != null )
	    return;
	String query = request.getQueryString();
	if (query == null)
	    return ;
	InputStream qis = new StringBufferInputStream(query);
	try {
	    queryParameters = new URLDecoder(qis).parse();
	} catch (Exception ex) {
	    throw new RuntimeException("Java implementation bug.");
	}
    }

    public int getContentLength()
    {
	return request.getContentLength();
    }
    
    public String getContentType()
    {
	return request.getContentType().toString();
    }
    
    protected ServletInputStream is = null;
    public ServletInputStream getInputStream()
    {
	// If alaredy computed return:
	if ( is != null )
	    return is;
	// Built it:
	InputStream stream = null;
        try {
	    if ((stream = request.getInputStream()) != null)
	        return is = new JigsawServletInputStream(stream);
        } catch (IOException ex) {
        }
	return null;
    }
    
    public String getParameter(String name)
    {
	prepareQueryParameters();
	if ( queryParameters != null )
	    return (String) queryParameters.get(name);
	else
	    return null;
    }
    
    public Hashtable getParameters()
    {
	prepareQueryParameters();
	return queryParameters;
    }
    
    public String getProtocol()
    {
	return request.getVersion();
    }
    
    public String getRemoteAddr()
    {
	return request.getClient().getInetAddress().toString();
    }

    public String getRemoteHost()
    {
	return request.getClient().getInetAddress().getHostName();
    }

    public String getServerName()
    {
	return request.getClient().getServer().getHost();
    }
    
    public int getServerPort()
    {
	return request.getClient().getServer().getLocalPort();
    }

    /**
     * HttpServletRequet implementation - 
     */

    public String getAuthType()
    {
	return (String) request.getState(AuthFilter.STATE_AUTHTYPE);
    }
    
    public long getDateHeader(String name, long i)
    {
	String value = getHeader(name);
	long longVal = i;
	
	if (value != null) {
	    try {
		return longVal = Date.parse(value);
	    } catch(Exception e) {
	    }
	}
	return longVal;
    }

    public String getHeader(int i) {
	return null;
    }

    public String getHeader(String name)
    {
	return request.getValue(name);
    }

    public String getHeaderName(int i)
    {
	return null;
    }

    public int getIntHeader(String name, int i)
    {
	String value = getHeader(name);
	int intVal = i;
	
	if (value != null) {
	    try {
		intVal = Integer.parseInt(value);
	    } catch(NumberFormatException eX) {
	    }
	}
	return intVal;
    }
    
    public  String getMethod()
    {
	return request.getMethod();
    }
    
    public  String getPathInfo()
    {
	return (String) request.getState(ServletWrapper.STATE_EXTRA_PATH);
    }
    
    public  String getPathTranslated()
    {
	return null;
    }
    
    public  String getQueryString()
    {
	// FIXME make sure this gets untranslated
	return request.getQueryString();
    }
    
    public String getRemoteUser()
    {
	return (String) request.getState(AuthFilter.STATE_AUTHUSER);
    }
    
    public  String getRequestURI()
    {
	return request.getURL().toExternalForm();
    }
    
    public  String getRequestPath()
    {
	return request.getURLPath();
    }
    
    public  String getServletPath()
    {
	return request.getTargetResource().getURLPath();
    }
    
    JigsawHttpServletRequest(Request request)
    {
	this.request = request;
    }
    

}
