// ByteRangeOutputStream.java
// $Id: ByteRangeOutputStream.java,v 1.2 1996/12/27 10:01:49 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.*;

import w3c.www.http.*;

class ByteRangeOutputStream extends InputStream {
    int              firstp = -1;
    int              lastp  = -1;
    RandomAccessFile in     = null;

    public int read()
	throws IOException
    {
	if ( firstp < lastp ) {
	    firstp++;
	    return ((int) in.readByte()) & 0xff;
	}
	return -1;
    }

    public int read(byte b[]) 
	throws IOException
    {
	return read(b, 0, b.length);
    }

    public int read(byte b[], int off, int len) 
	throws IOException
    {
	if (firstp < lastp) {
	    int send = Math.min(lastp-firstp, len);
	    in.readFully(b, off, send);
	    firstp += send;
	    return send;
	}
	return -1;
    }

    public void close()
	throws IOException
    {
	in.close();
    }

    public int available() {
	return lastp-firstp;
    }

    ByteRangeOutputStream(File file, int firstp, int lastp)
	throws IOException
    {
	this.firstp = firstp;
	this.lastp  = lastp;
	this.in     = new RandomAccessFile(file, "r");
	in.seek((long) firstp);
    }
}
