// ProxyRequestObserver.java
// $Id: ProxyRequestObserver.java,v 1.4 1996/11/06 13:19:16 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.proxy ;

import java.net.*;
import java.io.* ;

import w3c.www.protocol.http.*;
import w3c.www.http.*;

public class ProxyRequestObserver implements RequestObserver {
    /**
     * Our client, ie the one that sends us a request to fulfill.
     */
    w3c.jigsaw.http.Request request = null;
    /**
     * Call back, invoked by the HttpManager callback thread.
     * Each time a request status changes (due to progress in its processing)
     * this callback gets called, with the new status as an argument.
     * @param preq The pending request that has made some progress.
     * @param event The event to broadcast.
     */

    public void notifyProgress(RequestEvent event) {
	Request req = event.request;

	if ( event instanceof ContinueEvent ) {
	    // We need to forward this straight to the client:
	    try {
		request.getClient().sendContinue();
	    } catch (IOException ex) {
		// This will fail latter on too, forget about it (!)
	    }
	} else if ( event instanceof ConnectedEvent ) {
	    String mth = request.getMethod();
	    if ((event.server.getMajorVersion() == -1)
		&& (request.getMajorVersion() >= 1)
		&& (request.getMinorVersion() >= 1)
		&& (mth.equals("POST") || mth.equals("PUT"))) {
		// Send a fake 100 continue event:
		try {
		    request.getClient().sendContinue();
		} catch (IOException ex) {
		    // This will fail latter on too, forget about it (!)
		}
	    }
	}
    }

    public ProxyRequestObserver(w3c.jigsaw.http.Request request) {
	this.request = request;
    }

}
