// Directory.java
// $Id: Directory.java,v 1.8 1997/01/22 18:09:27 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.indexer ;

import java.util.*;
import java.io.* ;

import w3c.tools.store.*;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.formedit.* ;

/**
 * Directory description objects.
 * Those objects are template that allows the server to know how to index
 * new directories on the fly, through the resourceIndexer.
 * @see ResourceIndexer
 */


public class Directory extends HTTPResource {

    /**
     * Attribute index - Does this applies to directory below this one.
     */
    protected static int ATTR_GENERIC = -1 ;
    /**
     * Attribute index - The template for this directory.
     */
    protected static int ATTR_TEMPLATE = -1;

    static {
	Attribute a = null ;
	Class     cls = null ;
	try {
	    cls   = Class.forName("w3c.jigsaw.indexer.Directory") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The generic flag
	a = new BooleanAttribute("generic"
				 , Boolean.FALSE
				 , Attribute.EDITABLE) ;
	ATTR_GENERIC = AttributeRegistry.registerAttribute(cls, a) ;
	// The template:
	a = new AttributeHolderAttribute("template"
					 , null
					 , Attribute.EDITABLE);
	ATTR_TEMPLATE = AttributeRegistry.registerAttribute(cls, a);
    }

    /**
     * Get the default directory target class.
     */

    public HTTPResource getTemplate() {
	return (HTTPResource) getValue(ATTR_TEMPLATE, null);
    }

    public void setTemplate(HTTPResource template) {
	setValue(ATTR_TEMPLATE, template);
    }

    /**
     * Get the generic flag value.
     */

    public boolean getGenericFlag() {
	return getBoolean(ATTR_GENERIC, false) ;
    }

    /**
     * Initialize a template directory.
     * @param values Default attribute values.
     */

    public void initialize(Object values[]) {
	super.initialize(values);
	HTTPResource template = getTemplate();
	Hashtable    defs     = new Hashtable(11);
	if ( template == null ) {
	    defs.put("identifier", getIdentifier());
	    template = new DirectoryResource();
	    setTemplate(template);
	}
	defs.put("resource-store", getResourceStore());
	defs.put("server", getServer());
	template.initialize(defs);
    }

    /**
     * Create a new Directory template.
     */

    public static Directory makeDirectory(w3c.jigsaw.http.httpd server
					  , String name
					  , Class cls) {
	Directory dir  = new Directory() ;
	Hashtable defs = new Hashtable(3) ;
	defs.put("identifier", name) ;
 	defs.put("server", server);
	if ( cls != null ) {
	    try {
		HTTPResource template = (HTTPResource) cls.newInstance();
		template.setValue("identifier", name);
		defs.put("template", template);
	    } catch (Exception ex) {
		cls = null;
	    }
	}
	dir.initialize(defs) ;
	return dir ;
    }

}

