// ConnectionProp.java
// $Id: SocketConnectionProp.java,v 1.3 1997/01/17 10:07:35 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http.socket;

import java.io.* ;
import java.util.* ;

import w3c.tools.store.*;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.forms.* ;
import w3c.jigsaw.daemon.*;
import w3c.jigsaw.config.*;
import w3c.www.http.*;

public class SocketConnectionProp extends PropertySet {
    private static String title = "Socket connection properties";

    static {
	Class     c = null;
	Attribute a = null;
	
	try {
	    c = Class.forName("w3c.jigsaw.http.socket.SocketConnectionProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Minimum number of free spare threads
	a = new IntegerAttribute(SocketClientFactory.MINSPARE_FREE_P
			       , new Integer(SocketClientFactory.MINSPARE_FREE)
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of free spare threads
	a = new IntegerAttribute(SocketClientFactory.MAXSPARE_FREE_P
			       , new Integer(SocketClientFactory.MAXSPARE_FREE)
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of idle threads:
	a = new IntegerAttribute(SocketClientFactory.MAXSPARE_IDLE_P
			       , new Integer(SocketClientFactory.MAXSPARE_IDLE)
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of simultaneous connections:
	a = new IntegerAttribute(SocketClientFactory.MAXCLIENTS_P
			       , new Integer(SocketClientFactory.MAXCLIENTS)
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// Idle timeout for thread cache
	a = new IntegerAttribute(SocketClientFactory.IDLETO_P
			       , new Integer(SocketClientFactory.IDLETO)
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// Max number of threads
	a = new IntegerAttribute(SocketClientFactory.MAXTHREADS_P
				 , new Integer(SocketClientFactory.MAXTHREADS)
				 , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String giving the title for this property set.
     */

    public String getTitle() {
	return title;
    }

    SocketConnectionProp(String name, httpd server) {
	super(name, server);
    }
}
