// HTTPFilter.java
// $Id: HTTPFilter.java,v 1.1 1996/07/19 23:59:54 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http ;

public interface HTTPFilter {

    /**
     * The lookup stage filtering.
     * This filter is invoked during lookup, it can cancel the lookup operation
     * in progress, by either throwing an exception (in case of error), or
     * by returning <strong>true</strong>, in which case, the filter has
     * perform the whole lookup operation itself.
     * @param ls The current lookup state, describing the state of the lookup
     * operation in progress.
     * @param lr The current lookup result, describing the already computed
     * part of the lookup operation.
     * @return A boolean, <strong>true</strong> if lookup has been completed
     * by the filter, and nothing else need to be done to complete it. 
     * Otherwise lookup should continue normally, and the filter returns
     * <strong>false</strong>.
     * @exception HTTPException If some error occurs, and the whole 
     * lookup operation cannot be continued normally.
     */

    public boolean lookup(LookupState ls, LookupResult lr)
	throws HTTPException;

    /**
     * The filter's ingoing method is called before any request processing is
     * done by the target resource.
     * <p>This method can (if able) compute the whole request's reply, and 
     * return it. If processing should continue normally, then the filter
     * must return <strong>null</strong>.
     * @param request The request being processed.
     * @param filters The whole array of filters to be applied before
     * actually continuing the process.
     * @param fidx The index in the above array of the filter being called.
     * @return A Reply instance, if the filter knows how to compute it, or
     * <strong>null</strong> if the request processing should continue
     * normally.
     * @exception HTTPException If the filter fails.
     */

    public Reply ingoingFilter(Request request
			       , HTTPFilter filters[]
			       , int fidx)
	throws HTTPException;

    /**
     * The filter's outgoing method is called once the target resource has
     * computed a reply.
     * <p>This method can return a Reply instance, in which case, the
     * processing should be aborted, and  the returned reply should be emited
     * back to thye client. Otherwsie, if the filter returns <strong>null
     * </strong> the processing continues normally.
     * @param request The request being processed.
     * @param reply The original reply, as emited by the target resource, 
     * and which has already been processed by the first filters.
     * @param filters The whole array of filters to be applied before
     * actually continuing the process.
     * @param fidx The index in the above array of the filter being called.
     * @exception HTTPException If the filter fails.
     */

    public Reply outgoingFilter(Request request, Reply reply
				, HTTPFilter filters[]
				, int fidx)
	throws HTTPException;

}
