// CvsProp.java
// $Id: CvsProp.java,v 1.4 1997/01/17 09:50:23 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.cvs ;

import w3c.tools.store.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.config.*;
import w3c.cvs.*;

import w3c.www.protocol.http.HttpManager;

class CvsProp extends PropertySet {
    private static String title = "Cvs properties";

    static {
	Class c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.cvs.CvsProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Register the path of CVS binary
	a = new StringAttribute(CvsDirectory.CVSPATH_P,
				null,
				Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// register the path of the CVS Repository
	a = new StringAttribute(CvsDirectory.CVSROOT_P,
				null,
				Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// register the path of the cvs wrapper (the shell script that
	// runs Cvs in the right directory
	a = new StringAttribute(CvsDirectory.CVSWRAP_P,
				null,
				Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    CvsProp(String name, httpd server) {
	super(name, server);
    }
}
