// AdminProtocol reader

package w3c.jigsaw.admin;

import java.io.*;
import java.net.*;
import java.util.*;

import w3c.tools.store.*;
import w3c.jigsaw.resources.*;

class AdminReader {
    /**
     * The RemoteResource factory to create remote resource instances.
     */
    RemoteResourceFactory factory = null;
    /**
     * The client side admin object we are attached to.
     */
    protected AdminContext admin = null;
    
    protected RemoteResource readResource(URL parent
					  , String identifier
					  , DataInputStream in)
	throws IOException, AdminProtocolException
    {
	// Read the class hierarchy:
	Vector vector  = new Vector();
	String clsname = null;
	while ( ! (clsname = in.readUTF()).equals("") )
	    vector.addElement(clsname);
	String classes[] = new String[vector.size()];
	vector.copyInto(classes);
	// Create the RemoteResource with these infos:
	return factory.createRemoteResource(parent, identifier, classes);
    }
    
    protected Attribute[] readAttributes(DataInputStream in)
	throws IOException, AdminProtocolException
    {
	ObjectInputStream oin = new ObjectInputStream(in);
	try {
	    return (Attribute[]) oin.readObject();
	} catch (ClassNotFoundException ex) {
	    ex.printStackTrace();
	} catch (StreamCorruptedException ex) {
	    ex.printStackTrace();
	} catch (OptionalDataException ex) {
	    ex.printStackTrace();
	}
	throw new AdminProtocolException("Cannot restore attributes");
    }
    
    

    AdminReader(AdminContext admin) {
	this.admin   = admin;
	this.factory = new RemoteResourceFactory(admin);
    }
    
}


