package w3c.cvs;

import java.util.*;

class DirectoryEnumeration implements Enumeration {
    CvsEntry    next = null;
    Enumeration enum = null;
    
    private CvsEntry computeNextElement() {
	if ( enum == null ) 
	    return (next = null);
	while ((next == null) && enum.hasMoreElements()) {
	    CvsEntry entry = (CvsEntry) enum.nextElement();
	    if ( entry.isdir )
		next = entry;
	}
	return next;
    }

    public synchronized boolean hasMoreElements() {
	return ((next != null) || ((next = computeNextElement()) != null));
    }

    public synchronized Object nextElement() {
	if ( next == null ) {
	    if ((next = computeNextElement()) == null)
		throw new NoSuchElementException("invalid enum");
	}
	CvsEntry item = next;
	next = null;
	return item.name;
    }

    DirectoryEnumeration(Hashtable entries) {
	this.enum = (entries != null) ? entries.elements() : null;
    }

}
