// MIMETypeParameter.java
// $Id: MIMETypeParameter.java,v 1.1 1996/04/10 13:52:24 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

import java.io.DataOutputStream ;
import java.io.DataInputStream ;

/**
 * This class is used to represent MIME type parameters.
 * @see w3c.mime.MIMEType
 */

public class MIMETypeParameter {
    protected String name  = null ;
    protected String value = null ;
    
    /**
     * Get this parameter name.
     */

    public String getName() {
	return name ;
    }

    /**
     * Get this parameter value.
     * @return A String giving the unparsed parameter value.
     */

    public String getValue () {
	return value ;
    }

    /**
     * Construct a new MIME type parameter
     * @param name The name of the parameter.
     * @param value The value for this parameter, as a String.
     */

    MIMETypeParameter (String name, String value) {
	this.name  = name ;
	this.value = value ;
    }
}

