// Accept.java
// $Id: Accept.java,v 1.1 1996/04/10 13:52:04 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

/**
 * This class represents accpt headers, once parsed.
 */

public class Accept extends MIMEType {
    protected double quality = 1.0 ;
    protected int    mxb     = -1 ;

    /**
     * Get the <strong>mxb</strong> parameter.
     * @return The <strong>mxb</strong> parameter value, or <strong>-1</strong>
     *     if this parameter was left undefined.  
     */

    public int getMxb () {
	return mxb ;
    }

    /**
     * Get the quality for this accepted mime type. 
     * @return The quality requested, or <strong>1.0</strong> if none was
     *    specified.
     */

    public double getQuality () {
	return quality ;
    }

    /**
     * Get this accepted type specification.
     * @return A string describing the MIME type accord to the MIME 
     *    specification.
     */

    public String spec() {
	return type +"/" + subtype ;
    }

    public Accept (String spec) 
	throws MIMETypeFormatException 
    {
	super (spec) ;
	// look for the q and mxb parameters:
	if ( parameters != null ) {
	    for (int i = 0 ; i < parameters.length ; i++ ) {
		MIMETypeParameter p = parameters[i] ;
		if ( p.getName().equals ("q") ) {
		    try {
			quality = Double.valueOf(p.getValue()).doubleValue() ;
		    } catch (NumberFormatException e) {
			throw new MIMETypeFormatException (spec) ;
		    } 
		} else if ( p.getName().equals ("mxb") ) {
		    try {
			mxb = Integer.parseInt (p.getValue()) ;
		    } catch (NumberFormatException e) {
			throw new MIMETypeFormatException (spec) ;
		    }
		}
	    }
	}
    }
}
