// VMailMailFolder.java
// $Id: VMailMailFolder.java,v 1.1 1996/04/10 13:51:34 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mail ;

import java.io.* ;
import java.util.* ;

import w3c.mime.* ;

class MailMark {
    MailFolder folder = null ;
    int start  = -1 ;	// start of this mail in the bits array
    int body   = -1 ;   // start of mail body
    int length = -1 ;   // length of this mail (header size + body size)

    MailMark (MailFolder folder, int start) {
	this.folder = folder ;
	this.start  = start ;
	this.body   = -1 ;
	this.length = -1 ;
    }
}
    
class MailParser extends MIMEParser {
    MailMark   mark   = null ;
    int        isize  = -1 ;

    public MailMessage getMailMessage ()
	throws MIMEException
    {
	Hashtable headers  = new Hashtable (13) ;
	Hashtable rheaders = new Hashtable (13) ;
	// Parse the normal mail headers:
	try {
	    ch = input.read() ;
	    parse822Headers (rheaders) ;
	} catch (IOException e) {
	    throw new MIMEException ("IO Error while reading input.") ;
	} catch (MIMEParserException e) {
	    e.printStackTrace() ;
	    throw new MIMEException ("Invalid MIME message.") ;
	}
	// Add its mark as a fake MIME header:
	headers.put ("mark", mark) ;
	// Update the mark for header length:
	try {
	    mark.body = mark.start + isize - input.available() ;
	} catch (IOException e) {
	    System.out.println ("MailParser[getMailMessage]: "+e.getMessage());
	}
	return new MailMessage (mark.folder, headers, rheaders) ;
    }

    MailParser (MailMark mark, InputStream in) {
	super (in) ;
	this.mark  = mark ;
	try {
	    this.isize = in.available() ;
	} catch (IOException e) {
	    System.out.println ("MailParser[MailParser]: " + e.getMessage()) ;
	}
    }
}

public class VMailMailFolder implements MailFolder {
    byte     bits[] = null ;
    MailMark last   = null ;
    Vector   marks  = null ;
    int      idx    = 0 ;
    String filename = null ;

    /**
     * Get this folder name.
     */
    
    public String getName() {
	return filename ;
    }

    /**
     * Get a mail message, given its mark. As mail marks are private to this
     * package, this can only be used from here.
     * @param mark The mark of the message to be retrieved.
     * @return A MailMessage instance corresponding to the mark.
     */
     
    protected MailMessage getMailMessage (MailMark mark) {
	InputStream in = new ByteArrayInputStream (bits
						   , mark.start
						   , mark.length) ;
	MailParser  parser = new MailParser (mark, in) ;
	MailMessage msg    = null ;
	try {
	    msg = parser.getMailMessage () ;
	} catch (MIMEException e) {
	    throw new RuntimeException ("VMailMailFolder[getMessage]: "
					+ " unable to parse message.") ;
	}
	return msg ;
    }

    public void resetMailSequence () {
	idx = 0 ;
    }

    public MailMessage getNextMailMessage () {
	MailMark mark = null ;
	if ( idx < marks.size() ) 
	    mark = (MailMark) marks.elementAt (idx++) ;
	else
	    throw new RuntimeException ("VMailMailFolder[getNextMailMessage]: "
					+ "end of folder.") ;
	return getMailMessage (mark) ;
    }

    public boolean hasMoreMailMessages() {
	return idx < marks.size() ;
    }

    /**
     * Get a mail message body as an input stream.
     * @param msg The mail message whose body is to be retreievd.
     * @return An InputStream object, to read in the message body.
     */

    public InputStream getMailMessageInputStream (MailMessage msg) {
	MailMark mark = (MailMark) msg.getFieldObject ("mark") ;
	if ( mark.folder != this )
	    throw new RuntimeException("VMailMailFolder"
				       + "[getMailMessageInputStream]: "
				       + "invalid mark.") ;
	return new ByteArrayInputStream (bits
					 , mark.body
					 , mark.length-(mark.body-mark.start));
    }
	
    /**
     * Get a mail message by its integer index in the folder.
     * @param idx The position of the message in the folder.
     # @return The corresponding MailMessage instance or <strong>null</strong>.
     */

    public MailMessage getMailMessage (int idx) {
	if ( (idx < 0) || (idx >= marks.size()) ) 
	    return null ;
	return getMailMessage ((MailMark) marks.elementAt(idx)) ;
    }

    private void addMark (int start) {
	last = new MailMark (this, start) ;
	marks.addElement (last) ;
    }

    private void initialize () {
	// Go through the archive, marking each beginning mail messages in the
	// bits arrays.
	for (int i = 0 ; i < bits.length - 5 ; ) {
	    if ( ((i == 0) || (bits[i++] == (byte) '\n'))
		 && (bits[i] == (byte) 'F')
		 && (bits[i+1] == (byte) 'r')
		 && (bits[i+2] == (byte) 'o') 
		 && (bits[i+3] == (byte) 'm') 
		 && (bits[i+4] == (byte) ' ') ) {
		// Set the size of last mark:
		if ( last != null )
		    last.length = i - last.start ;
		// Add a new mark, skipping the delimiter line:
		int j = i + 5 ;
		while ( j < bits.length ) {
		    if ( bits[j] == '\n' )
			break ;
		    j++ ;
		}		    
		addMark (++j) ;
		i = j ;
	    } else {
		i++ ;
	    }
	}
	// Setup last mark length:
	if ( last != null )
	    last.length = bits.length - last.start ;
    }
    
    public VMailMailFolder (String name) 
	throws FileNotFoundException, IOException 
    {
	// gobble the whole file right in
	FileInputStream in = new FileInputStream (name) ;
	int size = in.available () ;
	if ( size <= 0 )
	    throw new RuntimeException ("VMailMailFolder: bad file.") ;
	this.bits = new byte[size] ;
	if ( in.read (bits) != size ) 
	    throw new RuntimeException ("VMailMailFolder: read file.") ;
	in.close () ;
	this.marks    = new Vector() ;
	this.filename = filename ;
	initialize () ;
    }

    //  Testing:
    public static void main (String args[])
	throws IOException, FileNotFoundException, MIMEException
    {
	MailFolder folder = new VMailMailFolder (args[0]) ;
	if (args.length == 1) {
	    // dump index:
	    for (int i = 0 ; folder.hasMoreMailMessages() ; i++) {
		MailMessage msg = folder.getNextMailMessage() ;
		MailMark mark = (MailMark) msg.getFieldObject("mark") ;
		System.out.println (i
				    + "["+mark.start+":"+mark.length+"]"
				    +" " + msg.getFieldString("subject")) ;
	    }
	} else {
	    for (int i = 1 ; i < args.length ; i++) {
		if ( args[i].equals ("-h") ) {
		    // dump headers:
		    int idx = Integer.parseInt (args[++i]) ;
		    MailMessage msg = folder.getMailMessage (idx) ;
		    msg.dump() ;
		} else if ( args[i].equals ("-b") ) {
		    // dump body:
		    int idx = Integer.parseInt (args[++i]) ;
		    MailMessage msg = folder.getMailMessage (idx) ;
		    byte buffer[]  = new byte[1024] ;
		    int  got       = -1 ;
		    InputStream in = msg.getInputStream() ;
		    while ((got = in.read(buffer)) > 0)
			System.out.print (new String(buffer, 0, 0, got)) ;
		    in.close() ;
		} else {
		    System.out.println ("MailFolder -h <idx> -b <idx>") ;
		    System.exit (1) ;
		}
	    }
	}
	System.exit (0) ;
    }

}
