// MailFolder.java
// $Id: MailFolder.java,v 1.1 1996/04/10 13:51:30 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mail ;

import java.io.InputStream ;

/**
 * A generic mail folder front-end. This interface describes a mail folder
 * front-end object. Take has been takento be able to implement it 
 * efficiently (ie caching).
 * <p>Two accessing methods are provided:</p>
 * <dl>
 * <dt>sequential</dt>
 * <dd>With this method, the folder is accessed sequentially.</dd>
 * <dt>indexed</dt>
 * <dd>With this method, the folder is accessed randomly.</dd>
 * </dl>
 */

public interface MailFolder {
    
    /**
     * Get this folder name.
     */

    public String getName() ;

    /**
     * Sequential access method. Does this folder has more messages ?
     * @return <strong>true</strong> if more messages are available.
     */

    public boolean hasMoreMailMessages() ;

    /**
     * Sequential access method. Get the next message out of this folder.
     * @return The next MailMessage contained by this folder.
     */

    public MailMessage getNextMailMessage () ;

    /**
     * Sequential access method. Reset the sequence, so that the user can
     * rescan the mail folder.
     */

    public void resetMailSequence() ;

    /**
     * Indexed access. Get the mail message whose number in the folder is
     * given.
     * @param idx The mail message index (its number in the sequence).
     * @return The corresponding MailMessage instance.
     */

    public MailMessage getMailMessage (int idx) ;

    /**
     * Get a mail body.
     * @param msg The MailMessage instance whose body is to be retreived.
     * @return An InputStream that will deliver the mail body.
     */

    public InputStream getMailMessageInputStream (MailMessage msg) ;

}
