// Statistics.java
// $Id: Statistics.java,v 1.1 1996/04/30 00:00:18 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.status ;

import java.util.Hashtable ;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.html.*;

/**
 * This class exports the server statistics.
 * It makes available a bunch of various parameters about the current
 * server, and uses the Refresh meta-tag (as the ThreadStat) to 
 * make them redisplay.
 * <p>This would benefit from being an applet.
 */

public class Statistics extends HTTPResource {
    protected static Integer REFRESH_DEFAULT = new Integer(5) ;

    /**
     * Attribute index - Our refresh interval.
     */
    protected static int ATTR_REFRESH = -1 ;
    
    static {
	Attribute a   = null ;
	Class     cls = null ;
	try {
	    cls = Class.forName("w3c.jigsaw.status.Statistics");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The refresh interval attribute:
	a = new IntegerAttribute("refresh"
				 , new Integer(5)
				 , Attribute.EDITABLE) ;
	ATTR_REFRESH = AttributeRegistery.registerAttribute(cls, a) ;
    }

    static String tbl = ("<p>Request processing times:"
			 + "<table border><tr>"
			 + "<th align=\"center\">min"
			 + "<th align=\"center\">avg"
			 + "<th align=\"center\">max"
			 + "</tr><tr>") ;

    /**
     * Get the current set of statistics.
     * Display the collected statistics in an HTML table.
     * @param request TYhe request to process.
     */

    public Reply get(Request request) {
	HtmlGenerator g = new HtmlGenerator("Statistics") ;
	g.meta("Refresh", getValue(ATTR_REFRESH, REFRESH_DEFAULT).toString());
	// Dump the statistics:
	httpdStatistics stats = getServer().getStatistics() ;
	// Hits and bytes:
	g.append("<ul><li>hits:", Long.toString(stats.getHitCount()));
	g.append("<li>bytes:", Long.toString(stats.getEmitedBytes()));
	g.append("</ul>");
	// Request times:
	g.append(tbl) ;
	g.append("<th align=\"center\">"
		 , Long.toString(stats.getMinRequestTime())) ;
	g.append("<th align=\"center\">"
		 , Long.toString(stats.getMeanRequestTime())) ;
	g.append("<th align=\"center\">"
		 , Long.toString(stats.getMaxRequestTime()));
	g.append("</table>") ;
	Reply reply = request.makeReply(HTTP.OK) ;
	reply.setStream (g) ;
	return reply ;
    }

}

