// StringArrayAttribute.java
// $Id: StringArrayAttribute.java,v 1.1 1996/04/10 13:50:30 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an StringArrayAttribute.
 */

public class StringArrayAttribute extends Attribute {

    /**
     * Is the given object a valid StringArrayAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof String[]) ;
    }
     
    /**
     * Pickle a String array to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object sa) 
	throws IOException
    {
	String strs[] = (String[]) sa ;
	out.writeInt(strs.length) ;
	for (int i = 0 ; i < strs.length ; i++)
	    out.writeUTF(strs[i]) ;
    }

    /**
     * Unpickle an String array from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of String[].
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	int    cnt    = in.readInt() ;
	String strs[] = new String[cnt] ;
	for (int i = 0 ; i < cnt ; i++)
	    strs[i] = in.readUTF() ;
	return strs ;
    }
     
    public StringArrayAttribute(String name, String def[], int flags) {
	super(name, def, flags) ;
    }

}
