// MIMETypeAttribute.java
// $Id: MIMETypeAttribute.java,v 1.1 1996/04/10 13:50:09 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

import w3c.mime.* ;

/**
 * The generic class of MIME type attributes.
 */

public class MIMETypeAttribute extends Attribute {

    /**
     * Is the given object a valid MIMETypeAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof MIMEType) || (obj == null) ;
    }
     
    /**
     * Pickle a MIME type to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object t) 
	throws IOException
    {
	out.writeUTF(((MIMEType) t).toString()) ;
    }

    /**
     * Unpickle a MIME type from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of String.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	try {
	    return new MIMEType(in.readUTF()) ;
	} catch (MIMETypeFormatException ex) {
	    throw new IOException("illegal MIME type.") ;
	}
    }
     

    public MIMETypeAttribute(String name, Object def, int flags) {
	super(name, def, flags) ;
    }
}
