// HTTPParser.java
// $Id: HTTPParser.java,v 1.2 1996/05/28 14:59:09 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

// FIXME:
// I could make thing faster by swalawing up the whole request (headers only)
// into a byte[], and than returning refs inside this array for field values.
// The point is in saving intermediate memory as much as possible.

package w3c.jigsaw.http ;

import java.util.Vector ;
import java.util.Hashtable ;
import java.util.Date ;

import java.io.* ;

import w3c.mime.* ;

public class HTTPParser extends MIMEParser {
    Client      client   = null ;

    /*
     * Although not formally defined by HTTP spec, wide words are usefull
     * A wide word is a sequaence of CHAR, except SP, HTAB, CR and LF. If the
     * ending is given by CR, this method also goble the LF. If it is given
     * by SP or HTAB, is gobles the remaining SP|HTAB.
     */

    protected String parseWWord () 
	throws MIMEParserException, IOException
    {
	bsize = 0 ;
      loop:
	while ( true ) {
	    switch (ch) {
	      case -1:
	      case '\n':
	      case ' ': 
	      case '\t': 
		  break loop ;
	      case '\r': 
		  ch = input.read() ;
		  break loop ;
	      default:
		  append ((char) ch) ;
		  break ;
	    }
	    ch = input.read() ;
	}
	if ( bsize <= 0 )
	    throw new HTTPParserException ("expected a WWord.") ;
	return new String (buffer, 0, 0, bsize) ;
    }

    /*
     * Parse current input stream as an HTTP request line. If all goes
     * well this method defines the following new fields in the
     * hashtable:
     * <dl><dt>method<dd>The method of the request,
     * <dt>uri<dd>The requested URL parsed as a String,
     * <dt>http=version<dd> The HTTP protocol versiopn used.
     * @parameter 	The Hashtable to fill.
     * @return A boolean, <strong>true</strong> if the decoded request is an
     *     0.9 request that doesn't need any more headers to be read.
     * @exception 	HTTPParserException, if RequestLine is unparsable.
     */


    protected boolean parseRequestLine (Hashtable into) 
	throws MIMEParserException, IOException
    {
	boolean broken = false ;
	// If we start with a '\r' or a '\n' skip them
	// This is due to a bug in netscape & Moasic keep connection. they
	// emit a false content-length in this case
	while ((ch == '\r') || (ch == '\n'))
	    ch = input.read() ;
	// Okay, parse the method, etc:
	String method  = parseToken (false) ; 
	expect (' ') ;
	String uri     = parseWWord () ;
	skipSpaces () ;
	switch (ch) {
	  case '\r':
	      ch = input.read() ;
	      // no break intentional
	  case '\n':
	      into.put ("http-version", "HTTP/0.9") ;
	      broken = true ;
	      break ;
	  default:
	      skipSpaces () ;
	      into.put ("http-version", parseWWord()) ;
	      if ( ch == '\r' )
		  ch = input.read() ;
	      expect ('\n') ;
	}
	into.put ("method", (Object) method) ;
	into.put ("uri", (Object) uri) ;
	return broken ;
    }

    /**
     * <p>The getRequest() activate the parsing of the client's input stream.
     * Before calling this method, the content of the request (if any) should
     * have been read.
     * <p>After getRequest returns, the client's input stream is set before the
     * first character of the content part of the request, which is the first
     * character of the next request if content-length is 0.
     */

    public Request getRequest () 
	throws HTTPParserException
    {
	Hashtable headers  = new Hashtable(23) ;
	Hashtable rheaders = new Hashtable(23) ;
	try {
	    ch = input.read() ;
	    if ( ! parseRequestLine (headers) ) 
		parse822Headers (rheaders) ;
	} catch (IOException e) {
	    String msg = "IOError while parsing request: " + e.getMessage() ;
	    throw new HTTPParserException (msg) ;
	} catch (MIMEParserException e) {
	    String msg = "Couldn't parse the request: " + e.getMessage() ;
	    throw new HTTPParserException (msg) ;
	}
	return new Request (client, headers, rheaders) ;
    }

    public HTTPParser (Client client) {
	super (client.input) ;
	this.client = client ;
    }
}
