// PostFileResource.java
// $Id: PostFileResource.java,v 1.1 1996/04/10 13:42:02 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import java.io.*;

import w3c.mime.* ;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.*;

/**
 * This resource demonstrates how Jigsaw can handle file upload through POST.
 * It is based on this <a
 * href=ftp://ietf.cnri.reston.va.us/internet-drafts/draft-ietf-html-fileupload-03.txt">
 * draft </a>.  
 * <p>The whole work is in MIME input stream handling, rather than here, as 
 * you can see. This class just dumps its inputed entities.
 */

public class PostFileResource extends FileResource {

    /**
     * Handle the post, wit its attached file.
     * @param request The request to handle.
     * @exception HTTPException If processing the request failed.
     */

    public Reply post (Request req) 
	throws HTTPException
    {
	// Check the form content type:
	MIMEType type = req.getContentType () ;
	if ( (type.match (MIMEType.MULTIPART_FORM_DATA) < 0)
	     || ( ! type.hasParameter ("boundary")) ) {
	    Reply error = req.makeReply(HTTP.BAD_REQUEST) ;
	    throw new HTTPException(error) ;
	}
	// Parse input:
	String sbound     = type.getParameterValue ("boundary") ;
	byte   boundary[] = new byte[sbound.length()] ;
	sbound.getBytes (0, boundary.length, boundary, 0) ;
	try {
	    MIMEMultipartInputStream in = null ;
	    in = new MIMEMultipartInputStream (req.getInputStream(), boundary);
	    while (in.nextInputStream()) {
		// these are themselves MIME streams (!)
		MIMEParser  parser  = new MIMEParser (in) ;
		MIMEHeaders headers = parser.getMIMEHeaders() ;
		System.out.println ("----- headers:") ;
		headers.dump() ;
		System.out.println ("----- body:") ;
		int  got      = -1 ;
		byte buffer[] = new byte[4096] ;
		while ((got = in.read(buffer)) > 0) 
		    System.out.println (new String (buffer, 0, 0, got)) ;
		System.out.println ("----- end of body") ;
	    }
	} catch (Exception e) {
	    Reply error = req.makeReply(HTTP.BAD_REQUEST) ;
	    error.setContent ("Invalid request: unable to access its entity.");
	    throw new HTTPException (error) ;
	}
	Reply reply = req.makeReply(HTTP.OK) ;
	reply.setContent ("Got the data !") ;
	return reply ;
    }

}
