// IntegerField.java
// $Id: IntegerField.java,v 1.1 1996/04/10 13:41:54 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.HtmlGenerator ;

public class IntegerField extends FormField {
    Integer value ;

    /**
     * Get this field value as an Object.
     * @return An instance of Object.
     */

    public Object getValue() {
	return value ;
    }

    /**
     * Set the field value, as an integer.
     * This method doesn't notify the form  handler of the change.
     * @param ival The new integer value.
     */

    public void setValue (int ival) {
	value = new Integer(ival) ;
    }

    /**
     * Set this integer field value to the given String value.
     * If the value is changed, than the handler for this field is notified
     * of the change through an appropriate method call.
     * @param nval The new string value for this field.
     * @return A boolean, <strong>true</strong> indicates that the field value
     *    has effectively changed.
     * @exception FormFieldException If the provided value didn't match
     *    the expected type for this field.
     */

    public boolean setValue (String nval) 
	throws FormFieldException
    {
	// Check for the field's unsetting:
	if ((nval == null) || nval.equals("")) {
	    boolean result = (value == null) ;
	    value = null ;
	    return result ;
	}
	// Parse the provided string into an integer:
	Integer ival = null ;
	try {
	    ival = new Integer (nval) ;
	} catch (NumberFormatException ex) {
	    throw new FormFieldException ("invalid number format in " + nval);
	}
	if ( ival.equals (value) )
	    return false ;
	value = ival ;
	return true ;
    }

    /**
     * Dump this field has a form element.
     * There is unfortunatelly no better way, right now to improve the
     * integer editor.
     * @param into The HtmlGenerator to dump the field to.
     */

    public void dump (HtmlGenerator into) {
	dumpTitle(into) ;
	into.append ("<th align=left><input type=\"text\""
		     + " name=\""+name+"\""
		     + " value=\""
		     + ((value==null) ? "" : value.toString())
		     + "\"></th>") ;
    }

    /*
     * Initialize a IntegerField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (Integer) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

					   
    public IntegerField (String name,String title, String url, Integer value) {
	super (name, title, url) ;
	this.value = (value == null) ? new Integer(0) : value ;
    }

    public IntegerField() {
    }

}
