// CheckBoxField.java
// $Id: CheckBoxField.java,v 1.1 1996/04/10 13:41:30 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.HtmlGenerator ;

public class CheckBoxField extends FormField {
    Boolean value = null ;

    /**
     * Get this field value.
     * @return An instance of Boolean.
     */

    public Object getValue() {
	return value ;
    }

    /**
     * Set this field value.
     * This method doesn't notify the form handler of the change./
     * @param bval The new field's value.
     */

    public void setValue(boolean bval) {
	value = (bval ? Boolean.TRUE : Boolean.FALSE) ;
    }

    /**
     * Set this boolean field value to the given string value.
     * If the field value is changed, than the handler gets notified,
     * otherwise, a FormFieldException is thrown.
     * @param nval The new string value for this field.
     * @return A boolean <strong>true</strong> if the field was changed.
     * @exception FormFieldException If the given value doesn't match
     *    the expected type for the field.
     */

    public boolean setValue(String nval) 
	throws FormFieldException
    {
	// The fact that this method gets called tells us the check is on
	return true ;
    }


    /**
     * Dump this field as a form element.
     * @param into The HtmlGenerator to dump the field into.
     */

    public void dump(HtmlGenerator into) {
	dumpTitle(into) ;
	into.append("<th align=left><input type=\"checkbox\" name=\""
		    +name
		    +"\" "+(value.booleanValue() ? "checked" : "")+"></th>");
    }

    /*
     * Initialize a CheckBoxField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (Boolean) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

    /**
     * Create a new check box field.
     * @param name The name of this field.
     * @param title It's title.
     * @param value Its default value.
     */

    public CheckBoxField(String name, String title, String url, boolean val) {
	super(name, title, url) ;
	this.value = (val ? Boolean.TRUE : Boolean.FALSE) ;
    }

    
}
