// BooleanField.java
// $Id: BooleanField.java,v 1.1 1996/04/10 13:41:26 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import java.util.* ;
import java.io.* ;

import w3c.jigsaw.forms.* ;
import w3c.jigsaw.html.HtmlGenerator ;

public class BooleanField extends FormField {
    Boolean value = Boolean.FALSE ;

    /**
     * Get this field value as an Object.
     * @return An instance of Object.
     */

    public Object getValue () {
	return value ;
    }

    /**
     * Set the fields value, as a boolean.
     * This method doesn't notify the form handler.
     * @param value The boolean value.
     */

    public void setValue (boolean bval) {
	value = (bval ? Boolean.TRUE : Boolean.FALSE) ;
    }

    /**
     * Set this field value to the given String value.
     * If the value is changed, than the handler for this field is notified
     * of the change through an appropriate method call.
     * @param nval The new string value for this field.
     * @return A boolean, <strong>true</strong> indicates that the field value
     *    has effectively changed.
     * @exception FormFieldException If the provided value didn't match
     *    the expected type for this field.
     */

    public boolean setValue (String nval) 
	throws FormFieldException
    {
	boolean changed = false ;
	if ((nval == null) || nval.equals("")) {
	    boolean result = (value != null) ;
	    value = null ;
	    return result ;
	}
	if ( nval.equalsIgnoreCase ("true") ) {
	    changed = (value == null) || (value.booleanValue() != true) ;
	    value   = Boolean.TRUE ;
	} else {
	    changed = (value == null) || (value.booleanValue() != false) ;
	    value   = Boolean.FALSE ;
	}
	return changed ;
    }

    /**
     * Dump this field has a form element.
     * @param into The HtmlGenerator to dump the field to.
     */

    public void dump (HtmlGenerator into) {
	dumpTitle(into) ;
	into.append ("<th align=left><select name=\""+name+"\">") ;
	if ((value != null) && value.booleanValue() ) {
	    into.append ("<option selected value=\"true\">true</option>");
	    into.append ("<option value=\"false\">false</option>") ;
	} else {
	    into.append ("<option value=\"true\">true</option>");
	    into.append ("<option selected value=\"false\">false</option>") ;
	}
	into.append ("</select></th>") ;
    }

    /*
     * Initialize a BooleanField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (Boolean) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

    public BooleanField (String name, String title, String url, Boolean bval) {
	super (name, title, url) ;
	this.value = bval ;
    }

    public BooleanField() {
    }

}
