// FormResourceEditor.java
// $Id: FormResourceEditor.java,v 1.2 1996/04/12 20:59:46 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.formedit;

import java.util.*;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;

 
public class FormResourceEditor extends ContainerResource 
    implements ResourceLocker 
{
    Hashtable loaded   = null ;
    Hashtable bytarget = null ;

    int       count  = 1 ;

    /**
     * Generate a new uniq identifier for the editor's resource.
     */

    protected String getNextURLPart() {
	return "editor@"+(count++);
    }

    /**
     * Resource locker implementation - This resource is going down.
     * @param resource The resource going down.
     */

    public synchronized void notifyResourceLockBreak(Resource r) {
	if ( ! (r instanceof HTTPResource) ) 
	    throw new RuntimeException ("*** Implementation bug") ;
	HTTPResource resource = (HTTPResource) r ;
	HTTPResource editor   = (HTTPResource) bytarget.get(resource.getURL());
	if ( editor != null ) {
	    loaded.remove(editor.getIdentifier()) ;
	    bytarget.remove(resource.getURL()) ;
	}
    }

    /**
     * Lookup the taregt we want to edit in the server space.
     * @param state A lookup state to pursue to find the target.
     * @return An instance of Resource, or <strong>null</strong>.
     */
    
    public HTTPResource lookupTarget(ContainerResource resource
				 , LookupState state)  
        throws HTTPException             
    {                        
        HTTPResource target = resource ;
	// Mark the lookup state as being internal:
	state.markInternal() ;
	// Lookup the target to be edited:
        while ( state.hasMoreComponents() ) { 
            if ((target == null) || ! (target instanceof ContainerResource)) 
                return null ; 
            resource = (ContainerResource) target ; 
            target   = resource.lookup(state) ; 
        } 
        return target ; 
    }    

    /**
     * lookup a resource in the editor space.
     * If we have started an editor for the resource, relocate to it, otherwise
     * create a new ediutor, install it, and return it.
     * @param state The current lookup state.
     * @@return A resource instance, or <strong>null</strong>
     * @exception HTTPException If something wen't wrong, or if a relocation
     *    is needed.
     */

    public HTTPResource lookup(LookupState state) 
	throws HTTPException
    {
	// Do we have an editor ready for this resource ?
	String       comp     = state.peekNextComponent() ;
	HTTPResource resource = (HTTPResource) loaded.get(comp) ;
	if ( resource != null ) {
	    state.getNextComponent() ;
	    return resource ;
	}
	// Lookup the target resource, from the server's root, and edit it:
	HTTPResource target = lookupTarget(getServer().getRoot(), state) ;
	if ( target == null )
	    return null ;
	// Check for access by target:
	resource = (HTTPResource) bytarget.get(target.getURL()) ;
	if ( resource != null ) {
	    Reply reloc = state.getRequest().makeReply(HTTP.MOVED_TEMPORARILY);
	    reloc.setLocation(resource.getURL()) ;
	    throw new HTTPException(reloc) ;
	}
	// Instantiate an editor for this target:
	Hashtable defs = new Hashtable(5);
	String    part = getNextURLPart() ;
	defs.put("identifier", part) ;
	defs.put("parent", this) ;
	defs.put("url", getURL() +"/" + part) ;
	defs.put("target", target) ;
	defs.put("server", getServer());
	HTTPResource editor = FormEditorFactory.getEditor(target);
	editor.initialize(defs) ;
	target.lock(this) ;
	// Install it in our loaded editor set, and relocate to it:
	loaded.put(part, editor) ;
	bytarget.put(target.getURL(), editor) ;
	Reply reloc = state.getRequest().makeReply(HTTP.MOVED_TEMPORARILY);
	reloc.setLocation(editor.getURL()) ;
	throw new HTTPException(reloc) ;
    }

    /**
     * If a get is performed directly on this resource, edit the root.
     * @param request The request to handle.
     */

    public Reply get(Request request)
	throws HTTPException
    {
	HTTPResource target = getServer().getRoot() ;
	// Check by target:
	HTTPResource resource = (HTTPResource) bytarget.get(target.getURL()) ;
	if ( resource != null ) {
	    Reply reloc = request.makeReply(HTTP.MOVED_TEMPORARILY);
	    reloc.setLocation(resource.getURL()) ;
	    throw new HTTPException(reloc) ;
	}
	// Instantiate an editor for this target:
	Hashtable defs = new Hashtable(5);
	String    part = getNextURLPart() ;
	defs.put("parent", this) ;
	defs.put("url", getURL() +"/" + part) ;
	defs.put("target", target) ;
	defs.put("server", getServer());
	HTTPResource editor = FormEditorFactory.getEditor(target);
	editor.initialize(defs) ;
	// Install it in our loaded editor set, and relocate to it:
	loaded.put(part, editor) ;
	bytarget.put(target.getURL(), editor) ;
	Reply reloc = request.makeReply(HTTP.MOVED_TEMPORARILY);
	reloc.setLocation(editor.getURL()) ;
	throw new HTTPException(reloc) ;
    }

    /**
     * initialize this resource editor.
     * @param values The default attribute values.
     */

    public void initialize(Object values[]) {
	super.initialize(values) ;
	// Some unfortunate hacking:
	this.loaded   = new Hashtable() ;
	this.bytarget = new Hashtable() ;
    }

}
