// FormEditorHelper.java
// $Id: FormEditorHelper.java,v 1.1 1996/04/10 13:43:18 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.formedit ;

import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;

/**
 * Some objects might require helper editors.
 * This interface is to be used by objects that require help editors to create
 * the form to edit their target. This helper object will just take care of
 * the editing of a single aspect of the global target (such as, say, one of
 * its filters).
 */


public interface FormEditorHelper {

    /**
     * Generate a form card to edit the provided target resource.
     * The provided target resource might be only a single aspect of a full
     * blown resource.
     * @param target The target resource to edit.
     * @param form The form this object editor should be inserted to.
     */

    public void generateFormCard(Resource target, FormResource form) ;
}
