// FilteredResourceEditor.java
// $Id: FilteredResourceEditor.java,v 1.2 1996/04/12 20:59:44 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.formedit;

import java.util.*;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;

class AddFilterHandler extends FormCardHandler {
    FilteredResource       target = null ;
    FilteredResourceEditor editor = null ;

    public String notifyEndProcessing(FormCardResource card, Request request) 
	throws FormProcessingException
    {
	Class cls = (Class) card.lookupField("class").getValue() ;
	if ( cls == null ) {
	    String msg = "Fill in the class of the filter you want to add.";
	    throw new FormProcessingException (msg) ;
	}
	// Create the filter, and add to the resource:
	ResourceFilter filter = null ;
	try {
	    filter = (ResourceFilter) cls.newInstance() ;
	    target.registerFilter(filter, null) ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    String msg = "Failed to create and attach filter to target: "
		+ ex.getMessage() ;
	    throw new FormProcessingException (msg);
	}
	// Add the card to edit this filter.
	editor.addFilterCard(filter) ;
	return null ;
    }

    AddFilterHandler(FilteredResourceEditor editor, FilteredResource target) {
	this.editor = editor ;
	this.target = target ;
    }

}

/**
 * Generic editor for filtered resources:
 */

public class FilteredResourceEditor extends GenericResourceEditor {

    /**
     * Get our target, as a filtered resource:
     */

    public FilteredResource getFilteredResourceTarget() {
	return (FilteredResource) getTarget() ;
    }

    /**
     * define the card to add new filters to our target.
     */

    protected void defineAddFiltersCard() {
	FilteredResource target  = getFilteredResourceTarget() ;
	AddFilterHandler handler = new AddFilterHandler(this, target) ;

	FormCardResource card    = defineCard(handler
					      , "AddFilter"
					      , "Add a filter to "
					      + target.getIdentifier());
	// The class of the filter:
	FormFieldInterface field = new ClassnameField("class"
						      , "Filter's class"
						      , null
						      , null) ;
	card.addField(field) ;
    }

    /**
     * Add a card for a newly created filter.
     * @param filter The newly created filter.
     */


    public void addFilterCard(ResourceFilter filter) {
	FilteredResource target = getFilteredResourceTarget() ;
	FormEditorHelper helper = FormHelperRegistery.getHelper(filter);
	if ( helper != null )
	    helper.generateFormCard(filter, this) ;   
    }

    /**
     * Define the cards for existing filters.
     * Each filter can create its own card in the form.
     */

    public void defineFiltersListCard() {
	FilteredResource target    = getFilteredResourceTarget() ;
	ResourceFilter   filters[] = target.getFilters() ;
	if ( filters == null )
	    return ;
	// For each filter, add an additional card:
	for (int i = 0 ; i < filters.length ; i++) {
	    ResourceFilter filter = filters[i] ;
	    FormEditorHelper h = FormHelperRegistery.getHelper(filter);
	    if ( h != null )
		h.generateFormCard(filters[i], this) ;
	}
    }
     
    /**
     * Define all the cards to edit a filtered resource:
     */

    protected void defineCards() {
	// Define our super cards:
	super.defineCards() ;
	// Define the card displaying existing filters:
	defineFiltersListCard() ;
	// Define the card to  add new filters:
	defineAddFiltersCard() ;
    }
}
