// CounterFilter.java
// $Id: CounterFilter.java,v 1.1 1996/04/12 20:59:23 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.filters;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

/**
 * Count the number of hits to the target.
 * This resource maintains the number of hits to some target resource, as
 * one of its persistent attribute.
 */

public class CounterFilter extends ResourceFilter {
    /**
     * Attribute index - The counter attribute.
     */
    protected static int ATTR_COUNTER = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;
	
	try {
	    cls = Class.forName("w3c.jigsaw.filters.CounterFilter") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// Declare the counter attribute
	a = new IntegerAttribute("counter"
				 , new Integer(0)
				 , Attribute.EDITABLE) ;
	ATTR_COUNTER = AttributeRegistery.registerAttribute(cls, a) ;
    }

    /**
     * We count all accesses, even the one that failed.
     * @param request The request being processed.
     */

    public synchronized int ingoingFilter(Request request) {
	int i = getInt (ATTR_COUNTER, 0) ;
	setInt(ATTR_COUNTER, i+1) ;
	return DontCallOutgoing ;
    }

}

