// AuthFilter.java
// $Id: AuthFilter.java,v 1.1 1996/04/10 13:38:04 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.auth ;

import java.util.*;
import java.io.*;

import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;

/**
 * General authentication filters.
 */

public class AuthFilter extends ResourceFilter {
    /**
     * Attribute index - The methods protected by the filter.
     */
    protected static int ATTR_METHODS = -1 ;
    /**
     * Attribute index - The realm name for this filter.
     */
    protected static int ATTR_REALM = -1;

    static {
	Attribute a   = null ;
	Class     cls = null ;
	try {
	    cls = Class.forName("w3c.jigsaw.auth.AuthFilter");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The protected methods
	a = new StringArrayAttribute("methods"
				     , null
				     , Attribute.EDITABLE) ;
	ATTR_METHODS = AttributeRegistery.registerAttribute(cls, a) ;
	// The realm name (to be resolved by the RealmFactory).
	a = new StringAttribute("realm"
				, null
				, Attribute.EDITABLE|Attribute.MANDATORY);
	ATTR_REALM = AttributeRegistery.registerAttribute(cls, a) ;
    }

    /**
     * Get the list of methods that this filter protect
     * @return An array of String giving the name of the protected methods,
     *    or <strong>null</strong>, in wich case <em>all</em> methods are
     *    to be protected.
     */

    public String[] getMethods() {
	return (String[]) getValue(ATTR_METHODS, null) ;
    }
    
    /**
     * Get the realm of this filter.
     */

    public String getRealm() {
	return (String) getValue(ATTR_REALM, null) ;
    }

    /**
     * Authenticate the request from the given client.
     * An authentication filter should only override this method.
     * @param request The request to be handled.
     * @exception HTTPException If authentication failed.
     */

    public void authenticate (Request request) 
	throws HTTPException
    {
	Reply error = request.makeReply(HTTP.UNAUTHORISED) ;
	error.setContent ("<p>Invalid server configuration</p>"
			  + "<p>The server defines an authentication filter "
			  + " with no <strong>authenticate</strong> method.");
	throw new HTTPException (error) ;
    }

    /**
     * Authenticate the given request for the given client. 
     * This method is invoked prior to any request handling on its target
     * entity. If the used authentication method allows so, AuthFilters 
     * should set the <strong>authuser</strong> attribute of the request.
     * @param request The request.
     * @exception HTTPException If authentication failed.
     */

    public int ingoingFilter (Request request) 
	throws HTTPException
    {
	String method    = request.getMethod() ;
	String methods[] = getMethods() ;
	if ( methods == null ) {
	    authenticate (request) ;
	    return DontCallOutgoing ;
	} else {
	    for (int i = 0 ; i < methods.length ; i++) {
		if ( methods[i].equalsIgnoreCase (method) ) {
		    authenticate (request) ;
		    return DontCallOutgoing ;
		}
	    }
	}
	return DontCallOutgoing ;
    }
    
}

