// CvsEntry.java
// $Id: CvsEntry.java,v 1.1 1996/04/10 13:35:33 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.cvs ;

import java.io.* ;

/**
 * This class implements the state of any entry associated to a directory.
 */

public class CvsEntry {
    public static final int STATUS_U  = 1 ;
    public static final int STATUS_A  = 2 ;
    public static final int STATUS_R  = 3 ;
    public static final int STATUS_M  = 4 ;
    public static final int STATUS_C  = 5 ;
    public static final int STATUS_Q  = 6 ;
    public static final int STATUS_OK = 7 ;

    File         file   = null ;
    int          status = -1 ;
    CvsDirectory cvs    = null ;

    /**
     * Get this entry name.
     */

    public String getName() {
	return file.getName() ;
    }

    /**
     * Get this entry absolute path name.
     */

    public String getAbsolutePath() {
	return file.getAbsolutePath() ;
    }

    /**
     * Get this entry status.
     */

    public int getStatus() {
	return status ;
    }

    /**
     * Get this entry log.
     */

    public String log() 
	throws CvsException
    {
	return cvs.log(this) ;
    }

    /**
     * Get this entry diffs against latest cvs version.
     */

    public String diff() 
	throws CvsException
    {
	return cvs.diff (this) ;
    }

    CvsEntry (CvsDirectory cvs, String name, int status) {
	this.cvs    = cvs ;
	this.file   = new File(cvs.getDirectory(), name) ;
	this.status = status ;
    }
    
}

