$! Create Mosaic version 2.0 on VMS.
$! This command procedure compiles and links Mosaic 2.0 in one go.
$! For a more controlled build you can use MMS.
$! Options: DEBUG, LUCIDA, 17_PT
$! Bjrn S. Nilsson, 25-Nov-1993
$!
$ On Error Then GoTo The_End
$ On Control_Y Then GoTo The_End
$ Set Symbol/Scope=(NoGlobal,NoLocal)
$ Platform = F$GetSYI("Arch_Name")
$ pwd = F$Environment("Default")
$ Args = P1 + "," + P2 + "," + P3 + "," + P4 + "," + P5 + "," + P6 + "," +-
   P7 + "," + P8
$ Args = F$Edit(Args,"Collapse,UPCase")
$ If F$Locate("DEB",Args) .EQ. F$Length(Args)
$  Then
$   COpt = "/Optim"
$   LOpt = "/NoTrace"
$  Else
$   COpt = "/NoOptim/Debug"
$   LOpt = "/Debug"
$  EndIf
$!
$ VMS_Extra = "NO_17_PT,NO_LUCIDA,"
$ If F$Locate("NO_17_PT",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("17_PT",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_17_PT,"
$  EndIf
$ If F$Locate("NO_LUCIDA",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("LUCIDA",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_LUCIDA,"
$  EndIf
$ IP = "UCX"
$ If F$Trnlnm("MULTINET") .NES. "" Then IP = "MULTINET"
$ If F$Trnlnm("TWG$TCP")  .NES. "" 
$ Then 
$ 	IP     = "WIN_TCP"	! let WIN_TCP be -- really PathWay
$	@[]def.com		!define the location of PathWay include files
$ Endif
$!
$! Do ALPHA specific stuff here..
$!
$ If Platform .EQS. "Alpha" 
$ Then 
$   COpt = COpt + "/Standard=VAXC"
$   If IP .EQS. "WIN_TCP" 
$   Then
$   COpt = COpt + "/prefix=(all_entries, except=("
$   axp_except_1 = "accept,bind,connect,listen,select,shutdown,socket,"  + -
"recv,send,recvfrom,recvmsg,sendto,sendmsg,readv,writev,"  + -
"gethostname,sethostname,getpeername,getsockname,getsockopt,setsockopt,"  + -
"getnetbyaddr,getnetbyname,getnetent,setnetent,endnetent,"
$   axp_except_2 = "getprotobyname,getprotobynumber,getprotoent,setprotoent,endprotoent,"  + -
"getservbyname,getservbyport,getservent,setservent,endservent,"  + -
"gethostbyname,gethostbyaddr,gethostent,sethostent,endhostent,"  + -
"inet_addr,inet_lnaof,inet_makeaddr,inet_netof,inet_ntoa,inet_network,"  + -
"htonl,htons,ntohl,ntohs," + -
"sin))"
$   Else
$     axp_except_1 = ""
$     axp_except_2 = ""
$   Endif
$ Endif
$ If IP .EQS. "MULTINET" .AND. Platform .EQS. "Alpha" Then -
   COpt = COpt + "/PREFIX=ANSI"
$ If F$Locate("DEB",Args) .NE. F$Length(Args) Then Show Symbol/Local *
$ Verify = F$Verify(1)
$!
$! Create [.libwww2]libwww.olb
$!
$ Set Default [.libwww2]
$ If F$Search("libwww.olb") .EQS. "" Then Library/Create/Log libwww.olb
$ If Platform .eqs. "Alpha" 
$ Then 
$   Comp = "CC" + COpt + axp_except_1 + axp_except_2 + "/Define=''IP'"
$ Else
$   Comp = "CC" + COpt + "/Define=''IP'"
$ Endif
$ 'Comp' HTAccess.c
$ 'Comp' HTAlert.c
$ 'Comp' HTAnchor.c
$ 'Comp' HTAtom.c
$ 'Comp' HTSort.c
$ 'Comp' HTChunk.c
$ 'Comp' HTFTP.c
$ 'Comp' HTFWriter
$ 'Comp' HTFile.c
$ 'Comp' HTFormat.c
$ 'Comp' HTGopher.c
$ 'Comp' HTInit.c
$ 'Comp' HTList.c
$ 'Comp' HTMIME.c
$ 'Comp' HTML.c
$ 'Comp' HTMLDTD.c
$ 'Comp' HTMLGen
$ 'Comp' HTNews.c
$ 'Comp' HTParse.c
$ 'Comp' HTPlain.c
$ 'Comp' HTMosaicHTML.c
$ 'Comp' HTString.c
$ 'Comp' HTTCP.c
$ 'Comp' HTTP.c
$ 'Comp' HTTelnet.c
$ 'Comp' HTWSRC.c
$ 'Comp' HTWriter.c
$ 'Comp' SGML.c
$ 'Comp' HTIcon.c
$ 'Comp' HTCompressed.c
$ 'Comp' HTAAUtil.c
$ 'Comp' HTAssoc.c
$ 'Comp' HTUU.c
$ 'Comp' HTAABrow.c
$ Library/Replace/Log libwww.olb *.obj
$!
$! Create [.libhtmlw]libhtmlw.olb
$!
$ Set Default [-.libhtmlw]
$ If F$Search("libhtmlw.olb") .EQS. "" Then Library/Create/Log libhtmlw.olb
$ If Platform .eqs. "Alpha" 
$ Then 
$   Comp = "CC" + COpt + axp_except_1 + axp_except_2 + "/Define=(MOTIF,XMOSAIC,''IP')"
$ Else
$   Comp = "CC" + COpt + "/Define=(MOTIF,XMOSAIC,''IP')"
$ Endif
$ 'Comp' HTML.c
$ 'Comp' HTMLlists.c
$ 'Comp' HTMLformat.c
$ 'Comp' HTMLparse.c
$ 'Comp' HTMLimages.c
$ 'Comp' HTMLwidgets.c
$ 'Comp' HTML-PSformat.c
$ 'Comp' HTMLjot.c
$ Library/Replace/Log libhtmlw.olb *.obj
$!
$! Create [.libxmx]libxmx.olb
$!
$ Set Default [-.libXmx]
$ If F$Search("libXmx.olb") .EQS. "" Then Library/Create/Log libXmx.olb
$ If Platform .eqs. "Alpha" 
$ Then 
$   Comp = "CC" + COpt + axp_except_1 + axp_except_2 + "/Define=''IP'"
$ Else
$   Comp = "CC" + COpt + "/Define=''IP'"
$ Endif
$ 'Comp' Xmx.c
$ 'Comp' Xmx2.c
$ Library/Replace/Log libXmx.olb *.obj
$!
$! Compile the [.src] modules.
$!
$ Set Default [-.src]
$ If Platform .eqs. "Alpha" 
$ Then 
$   Comp = "CC" + COpt + axp_except_1 + axp_except_2 + "/Define=(''VMS_Extra'''IP')"
$ Else
$   Comp = "CC" + COpt + "/Define=(''VMS_Extra'''IP')"
$ Endif
$ If IP .NES. "WIN_TCP"
$ Then
$   Define Sys     SYS$Library
$   Define Netinet SYS$Library
$ Endif
$ Topdir = F$Environment("Default")-"SRC]"
$ Define LIBWWW2   'Topdir'LIBWWW2]
$ Define LIBXMX    'Topdir'LIBXMX]
$ Define LIBHTMLW  'Topdir'LIBHTMLW]
$ If Platform .EQS. "Alpha"
$  Then
$    Define DECC$User_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$    If IP .NES. "WIN_TCP" Then Define DECC$System_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$  Else
$    Define VAXC$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$    Define C$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
$  EndIf
$ 'Comp' main.c
$ 'Comp' gui.c
$ 'Comp' gui-dialogs.c
$ 'Comp' gui-menubar.c
$ 'Comp' gui-documents.c
$ 'Comp' mo-www.c
$ 'Comp' mo-dtm.c
$ 'Comp' hotlist.c
$ 'Comp' whine.c
$ 'Comp' history.c
$ 'Comp' annotate.c
$ 'Comp' pan.c
$ 'Comp' grpan.c
$ 'Comp' grpan-www.c
$ 'Comp' audan.c
$ 'Comp' globalhist.c
$ 'Comp' img.c
$ 'Comp' picread.c
$ 'Comp' xpmhash.c
$ 'Comp' xpmread.c
$ 'Comp' gifread.c
$ 'Comp' pixmaps.c
$ 'Comp' medcut.c
$ 'Comp' mo-hdf.c
$!
$! Finally link ...
$!
$ If IP .eqs. "WIN_TCP" Then IP = "PATHWAY"
$!
$ Link'LOpt'/Exe=mosaic.exe main.obj,gui.obj,gui-dialogs.obj,gui-menubar.obj,-
   gui-documents.obj,mo-www.obj,mo-dtm.obj,hotlist.obj,whine.obj,history.obj,-
   annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,globalhist.obj,-
   img.obj,picread.obj,xpmhash.obj,xpmread.obj,gifread.obj,pixmaps.obj,-
   medcut.obj,mo-hdf.obj,-
   [-.libhtmlw]libhtmlw.olb/Lib,[-.libxmx]libxmx.olb/Lib,-
   [-.libwww2]libwww.olb/Lib,[]'IP'.Opt/Opt
$ xxx = F$Verify(Verify)
$ Write SYS$Output "Linking done. Welcome to VMS Mosaic 2.0"
$ Set Default 'pwd'
$ Write SYS$Output "The executable is in [.src]Mosaic.exe"
$ Dir/Date=Modif/Size=All [.src]Mosaic.exe
$The_End:
$ xxx = F$Verify(Verify)
$ If F$Trnlnm("SYS","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SYS
$ If F$Trnlnm("NETINET","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process NETINET
$ If F$Trnlnm("LIBHTMLW","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBHTMLW
$ If F$Trnlnm("LIBWWW","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBWWW
$ If F$Trnlnm("DECC$User_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$User_Include
$ If F$Trnlnm("DECC$System_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$System_Include
$ If F$Trnlnm("VAXC$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process VAXC$Include
$ Set Default 'pwd'
