! MMS description file for LIBWWW2
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
! Mosaic version 2.4 20-Aug-1994
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
! Add a MULTINET=1 MACRO when using MultiNet TCP/IP.
! Add a DEBUG=1    MACRO when debugging.
! Add a DECC=1     MACRO when compiling with DEC C.
! Add a NOWAIS=1   MACRO when compiling without direct WAIS support.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!
! Define a default news host if you wish:
!NEWSD="DEFAULT_NEWS_HOST=""dxcern.cern.ch""",

CC = CC
LIBTARGET = libwww.olb
.FIRST
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.IFDEF NOWAIS
.ELSE
	@ Topdir = F$Environment("Default")-"LIBWWW2]"
	@ Define WAIS_IR  'Topdir'FREEWAIS-0_3.IR]
.IFDEF DECC
	@ Define DECC$User_Include 'F$Environment("Default")',WAIS_IR
	@ Define DECC$System_Include 'F$Environment("Default")',WAIS_IR,SYS
.ELSE
	@ Define C$Include 'F$Environment("Default")',WAIS_IR
	@ Define VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS
.ENDIF
WAISDEF=DIRECT_WAIS,
WAISDEFS=DIRECT_WAIS
WAISMODULES = HTWAIS
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/Standard=VAXC $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=/Standard=VAXC
.ENDIF
.ENDIF
.ELSE
CQUALC=
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALC)
.ELSE
CQUAL = $(CQUALC)
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=($(WAISDEF)$(NEWSD)MULTINET)
.ENDIF

.IFDEF PATHWAY
CDEFS = /Define=($(WAISDEF)$(NEWSD)WIN_TCP)
.ENDIF

.IFDEF CDEFS
.ELSE
CDEFS=/Define=($(NEWSD)$(WAISDEFS))
.ENDIF

BASEMODULES = \
 HTAccess \
 HTAlert \
 HTAnchor \
 HTAtom \
 HTSort \
 HTChunk \
 HTFTP \
 HTFWriter \
 HTFile \
 HTFormat \
 HTGopher \
 HTInit \
 HTList \
 HTMIME \
 HTML \
 HTMLDTD \
 HTMLGen \
 HTNews \
 HTParse \
 HTPlain \
 HTMosaicHTML \
 HTString \
 HTTCP \
 HTTP \
 HTTelnet \
 HTWSRC \
 HTWriter \
 SGML \
 HTIcon \
 HTCompressed \
 HTAAUtil \
 HTAssoc \
 HTUU \
 HTAABrow

MODULES = $(BASEMODULES) $(WAISMODULES)
CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

.IFDEF PATHWAY
.FIRST
	@ @[-.TWG]def
.ENDIF

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libwww.obj built."

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.C

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

