! MMS description file for LIBHTMLW
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
! Motif 1.2 support added on 3-Jun-1994
! Mosaic 2.4 20-Aug-1994
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
!       $ MMS/MACRO=(PATHWAY=1)         for Pathway
! Add a DEBUG=1 macro when debugging.
! Add a DECC=1 macro when compiling with DEC C.
! Add a MOTIF1_2 macro when Motif 1.2 is installed.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

CC = cc
LIBTARGET = libhtmlw.olb


.IFDEF MOTIF1_2
MOTIF = MOTIF,MOTIF1_2
.ELSE
MOTIF = MOTIF
.ENDIF

.IFDEF PATHWAY

.IFDEF DECC
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/Standard=VAXC $(CC_PREFIX_NO_SIN)
.ELSE
CQUALC=
.ENDIF
CDEFS = /DEFINE=($(MOTIF),XMOSAIC)

.ELSE ! Not PATHWAY

.IFDEF MULTINET
.IFDEF DECC
CQUALC=/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=
.ENDIF
CDEFS = /DEFINE=($(MOTIF),XMOSAIC,MULTINET)
.ELSE

!UCX
.IFDEF DECC
CQUALC=/Standard=VAXC
.ELSE
CQUALC=
.ENDIF
CDEFS = /DEFINE=($(MOTIF),XMOSAIC)
.ENDIF
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALC)
.ELSE
CQUAL = $(CQUALC)
.ENDIF

.FIRST
.IFDEF PATHWAY
  @[-.twg]def
.ELSE
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ENDIF

MODULES =  HTML HTMLlists HTMLformat HTMLparse HTMLimages HTMLwidgets \
 HTML-PSformat HTMLjot

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libhtmlw.olb built."

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.c

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

