! MMS description file for LIBWAIS
! Bjorn S. Nilsson, Aleph, CERN, 20-Aug-1994
! Mosaic version 2.4 20-Aug-1994
! Only routines needed for Mosaic 2.4 are included in this compilation
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
! Add a DECC=1     MACRO when DEC C is used.
! Add a MULTINET=1 MACRO when MultiNet TCP/IP is used.
! Add a DEBUG=1    MACRO when debugging.
!

CC = CC
LIBTARGET = libwais.olb

.IFDEF DECC
.IFDEF MULTINET
CQUALC=/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=/Standard=VAXC
.ENDIF
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALC)
.ELSE
CQUAL = $(CQUALC)
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=MULTINET
.ENDIF

MODULES = \
  cutil \
  futil \
  panic \
  ui \
  wmessage \
  wprot \
  wutil \
  zprot \
  ztype1 \
  zutil

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

.FIRST
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libwais.obj built."

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.C

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

